<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelOptionModify StructType
 * @subpackage Structs
 */
class JP_HotelOptionModify extends AbstractStructBase
{
    /**
     * The ModifyCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_BookingCode
     */
    public $ModifyCode;
    /**
     * The Supplier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Supplier
     */
    public $Supplier;
    /**
     * The Board
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Board
     */
    public $Board;
    /**
     * The HotelRooms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_HotelRoom
     */
    public $HotelRooms;
    /**
     * The Prices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Price
     */
    public $Prices;
    /**
     * The AdditionalElements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelAdditionalElements
     */
    public $AdditionalElements;
    /**
     * The CancellationPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CancellationPolicyRules
     */
    public $CancellationPolicy;
    /**
     * The CancellationPolicyCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CancellationPolicyRules
     */
    public $CancellationPolicyCost;
    /**
     * The PaymentDestination
     * @var bool
     */
    public $PaymentDestination;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The NonRefundable
     * @var bool
     */
    public $NonRefundable;
    /**
     * Constructor method for JP_HotelOptionModify
     * @uses JP_HotelOptionModify::setModifyCode()
     * @uses JP_HotelOptionModify::setSupplier()
     * @uses JP_HotelOptionModify::setBoard()
     * @uses JP_HotelOptionModify::setHotelRooms()
     * @uses JP_HotelOptionModify::setPrices()
     * @uses JP_HotelOptionModify::setAdditionalElements()
     * @uses JP_HotelOptionModify::setCancellationPolicy()
     * @uses JP_HotelOptionModify::setCancellationPolicyCost()
     * @uses JP_HotelOptionModify::setPaymentDestination()
     * @uses JP_HotelOptionModify::setStatus()
     * @uses JP_HotelOptionModify::setNonRefundable()
     * @param \StructType\JP_BookingCode $modifyCode
     * @param \StructType\JP_Supplier $supplier
     * @param \StructType\JP_Board $board
     * @param \ArrayType\ArrayOfJP_HotelRoom $hotelRooms
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @param \StructType\JP_HotelAdditionalElements $additionalElements
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicy
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicyCost
     * @param bool $paymentDestination
     * @param string $status
     * @param bool $nonRefundable
     */
    public function __construct(\StructType\JP_BookingCode $modifyCode = null, \StructType\JP_Supplier $supplier = null, \StructType\JP_Board $board = null, \ArrayType\ArrayOfJP_HotelRoom $hotelRooms = null, \ArrayType\ArrayOfJP_Price $prices = null, \StructType\JP_HotelAdditionalElements $additionalElements = null, \StructType\JP_CancellationPolicyRules $cancellationPolicy = null, \StructType\JP_CancellationPolicyRules $cancellationPolicyCost = null, $paymentDestination = null, $status = null, $nonRefundable = null)
    {
        $this
            ->setModifyCode($modifyCode)
            ->setSupplier($supplier)
            ->setBoard($board)
            ->setHotelRooms($hotelRooms)
            ->setPrices($prices)
            ->setAdditionalElements($additionalElements)
            ->setCancellationPolicy($cancellationPolicy)
            ->setCancellationPolicyCost($cancellationPolicyCost)
            ->setPaymentDestination($paymentDestination)
            ->setStatus($status)
            ->setNonRefundable($nonRefundable);
    }
    /**
     * Get ModifyCode value
     * @return \StructType\JP_BookingCode|null
     */
    public function getModifyCode()
    {
        return $this->ModifyCode;
    }
    /**
     * Set ModifyCode value
     * @param \StructType\JP_BookingCode $modifyCode
     * @return \StructType\JP_HotelOptionModify
     */
    public function setModifyCode(\StructType\JP_BookingCode $modifyCode = null)
    {
        $this->ModifyCode = $modifyCode;
        return $this;
    }
    /**
     * Get Supplier value
     * @return \StructType\JP_Supplier|null
     */
    public function getSupplier()
    {
        return $this->Supplier;
    }
    /**
     * Set Supplier value
     * @param \StructType\JP_Supplier $supplier
     * @return \StructType\JP_HotelOptionModify
     */
    public function setSupplier(\StructType\JP_Supplier $supplier = null)
    {
        $this->Supplier = $supplier;
        return $this;
    }
    /**
     * Get Board value
     * @return \StructType\JP_Board|null
     */
    public function getBoard()
    {
        return $this->Board;
    }
    /**
     * Set Board value
     * @param \StructType\JP_Board $board
     * @return \StructType\JP_HotelOptionModify
     */
    public function setBoard(\StructType\JP_Board $board = null)
    {
        $this->Board = $board;
        return $this;
    }
    /**
     * Get HotelRooms value
     * @return \ArrayType\ArrayOfJP_HotelRoom|null
     */
    public function getHotelRooms()
    {
        return $this->HotelRooms;
    }
    /**
     * Set HotelRooms value
     * @param \ArrayType\ArrayOfJP_HotelRoom $hotelRooms
     * @return \StructType\JP_HotelOptionModify
     */
    public function setHotelRooms(\ArrayType\ArrayOfJP_HotelRoom $hotelRooms = null)
    {
        $this->HotelRooms = $hotelRooms;
        return $this;
    }
    /**
     * Get Prices value
     * @return \ArrayType\ArrayOfJP_Price|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * Set Prices value
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @return \StructType\JP_HotelOptionModify
     */
    public function setPrices(\ArrayType\ArrayOfJP_Price $prices = null)
    {
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Get AdditionalElements value
     * @return \StructType\JP_HotelAdditionalElements|null
     */
    public function getAdditionalElements()
    {
        return $this->AdditionalElements;
    }
    /**
     * Set AdditionalElements value
     * @param \StructType\JP_HotelAdditionalElements $additionalElements
     * @return \StructType\JP_HotelOptionModify
     */
    public function setAdditionalElements(\StructType\JP_HotelAdditionalElements $additionalElements = null)
    {
        $this->AdditionalElements = $additionalElements;
        return $this;
    }
    /**
     * Get CancellationPolicy value
     * @return \StructType\JP_CancellationPolicyRules|null
     */
    public function getCancellationPolicy()
    {
        return $this->CancellationPolicy;
    }
    /**
     * Set CancellationPolicy value
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicy
     * @return \StructType\JP_HotelOptionModify
     */
    public function setCancellationPolicy(\StructType\JP_CancellationPolicyRules $cancellationPolicy = null)
    {
        $this->CancellationPolicy = $cancellationPolicy;
        return $this;
    }
    /**
     * Get CancellationPolicyCost value
     * @return \StructType\JP_CancellationPolicyRules|null
     */
    public function getCancellationPolicyCost()
    {
        return $this->CancellationPolicyCost;
    }
    /**
     * Set CancellationPolicyCost value
     * @param \StructType\JP_CancellationPolicyRules $cancellationPolicyCost
     * @return \StructType\JP_HotelOptionModify
     */
    public function setCancellationPolicyCost(\StructType\JP_CancellationPolicyRules $cancellationPolicyCost = null)
    {
        $this->CancellationPolicyCost = $cancellationPolicyCost;
        return $this;
    }
    /**
     * Get PaymentDestination value
     * @return bool|null
     */
    public function getPaymentDestination()
    {
        return $this->PaymentDestination;
    }
    /**
     * Set PaymentDestination value
     * @param bool $paymentDestination
     * @return \StructType\JP_HotelOptionModify
     */
    public function setPaymentDestination($paymentDestination = null)
    {
        // validation for constraint: boolean
        if (!is_null($paymentDestination) && !is_bool($paymentDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($paymentDestination)), __LINE__);
        }
        $this->PaymentDestination = $paymentDestination;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_AvailStatus::valueIsValid()
     * @uses \EnumType\JP_AvailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_HotelOptionModify
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_AvailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\JP_AvailStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get NonRefundable value
     * @return bool|null
     */
    public function getNonRefundable()
    {
        return $this->NonRefundable;
    }
    /**
     * Set NonRefundable value
     * @param bool $nonRefundable
     * @return \StructType\JP_HotelOptionModify
     */
    public function setNonRefundable($nonRefundable = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonRefundable) && !is_bool($nonRefundable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($nonRefundable)), __LINE__);
        }
        $this->NonRefundable = $nonRefundable;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_HotelOptionModify
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
