<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Flight StructType
 * @subpackage Structs
 */
class JP_Flight extends AbstractStructBase
{
    /**
     * The Routes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Routes
     */
    public $Routes;
    /**
     * The Prices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Price
     */
    public $Prices;
    /**
     * The AdditionalElements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_AdditionalElements
     */
    public $AdditionalElements;
    /**
     * The Rules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_FlightRule
     */
    public $Rules;
    /**
     * The InfoExtra
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_InfoExtra
     */
    public $InfoExtra;
    /**
     * The OptionalFares
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_OptionalFares
     */
    public $OptionalFares;
    /**
     * The FareType
     * @var string
     */
    public $FareType;
    /**
     * The AvailableSeats
     * @var int
     */
    public $AvailableSeats;
    /**
     * The Number
     * @var string
     */
    public $Number;
    /**
     * The Direction
     * @var string
     */
    public $Direction;
    /**
     * The LowCost
     * @var bool
     */
    public $LowCost;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The ICode
     * @var string
     */
    public $ICode;
    /**
     * The SearchMore
     * @var bool
     */
    public $SearchMore;
    /**
     * The Order
     * @var int
     */
    public $Order;
    /**
     * The Source
     * @var string
     */
    public $Source;
    /**
     * The BrandedCode
     * @var string
     */
    public $BrandedCode;
    /**
     * Constructor method for JP_Flight
     * @uses JP_Flight::setRoutes()
     * @uses JP_Flight::setPrices()
     * @uses JP_Flight::setAdditionalElements()
     * @uses JP_Flight::setRules()
     * @uses JP_Flight::setInfoExtra()
     * @uses JP_Flight::setOptionalFares()
     * @uses JP_Flight::setFareType()
     * @uses JP_Flight::setAvailableSeats()
     * @uses JP_Flight::setNumber()
     * @uses JP_Flight::setDirection()
     * @uses JP_Flight::setLowCost()
     * @uses JP_Flight::setRatePlanCode()
     * @uses JP_Flight::setStatus()
     * @uses JP_Flight::setICode()
     * @uses JP_Flight::setSearchMore()
     * @uses JP_Flight::setOrder()
     * @uses JP_Flight::setSource()
     * @uses JP_Flight::setBrandedCode()
     * @param \StructType\JP_Routes $routes
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @param \StructType\JP_AdditionalElements $additionalElements
     * @param \ArrayType\ArrayOfJP_FlightRule $rules
     * @param \StructType\JP_InfoExtra $infoExtra
     * @param \StructType\JP_OptionalFares $optionalFares
     * @param string $fareType
     * @param int $availableSeats
     * @param string $number
     * @param string $direction
     * @param bool $lowCost
     * @param string $ratePlanCode
     * @param string $status
     * @param string $iCode
     * @param bool $searchMore
     * @param int $order
     * @param string $source
     * @param string $brandedCode
     */
    public function __construct(\StructType\JP_Routes $routes = null, \ArrayType\ArrayOfJP_Price $prices = null, \StructType\JP_AdditionalElements $additionalElements = null, \ArrayType\ArrayOfJP_FlightRule $rules = null, \StructType\JP_InfoExtra $infoExtra = null, \StructType\JP_OptionalFares $optionalFares = null, $fareType = null, $availableSeats = null, $number = null, $direction = null, $lowCost = null, $ratePlanCode = null, $status = null, $iCode = null, $searchMore = null, $order = null, $source = null, $brandedCode = null)
    {
        $this
            ->setRoutes($routes)
            ->setPrices($prices)
            ->setAdditionalElements($additionalElements)
            ->setRules($rules)
            ->setInfoExtra($infoExtra)
            ->setOptionalFares($optionalFares)
            ->setFareType($fareType)
            ->setAvailableSeats($availableSeats)
            ->setNumber($number)
            ->setDirection($direction)
            ->setLowCost($lowCost)
            ->setRatePlanCode($ratePlanCode)
            ->setStatus($status)
            ->setICode($iCode)
            ->setSearchMore($searchMore)
            ->setOrder($order)
            ->setSource($source)
            ->setBrandedCode($brandedCode);
    }
    /**
     * Get Routes value
     * @return \StructType\JP_Routes|null
     */
    public function getRoutes()
    {
        return $this->Routes;
    }
    /**
     * Set Routes value
     * @param \StructType\JP_Routes $routes
     * @return \StructType\JP_Flight
     */
    public function setRoutes(\StructType\JP_Routes $routes = null)
    {
        $this->Routes = $routes;
        return $this;
    }
    /**
     * Get Prices value
     * @return \ArrayType\ArrayOfJP_Price|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * Set Prices value
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @return \StructType\JP_Flight
     */
    public function setPrices(\ArrayType\ArrayOfJP_Price $prices = null)
    {
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Get AdditionalElements value
     * @return \StructType\JP_AdditionalElements|null
     */
    public function getAdditionalElements()
    {
        return $this->AdditionalElements;
    }
    /**
     * Set AdditionalElements value
     * @param \StructType\JP_AdditionalElements $additionalElements
     * @return \StructType\JP_Flight
     */
    public function setAdditionalElements(\StructType\JP_AdditionalElements $additionalElements = null)
    {
        $this->AdditionalElements = $additionalElements;
        return $this;
    }
    /**
     * Get Rules value
     * @return \ArrayType\ArrayOfJP_FlightRule|null
     */
    public function getRules()
    {
        return $this->Rules;
    }
    /**
     * Set Rules value
     * @param \ArrayType\ArrayOfJP_FlightRule $rules
     * @return \StructType\JP_Flight
     */
    public function setRules(\ArrayType\ArrayOfJP_FlightRule $rules = null)
    {
        $this->Rules = $rules;
        return $this;
    }
    /**
     * Get InfoExtra value
     * @return \StructType\JP_InfoExtra|null
     */
    public function getInfoExtra()
    {
        return $this->InfoExtra;
    }
    /**
     * Set InfoExtra value
     * @param \StructType\JP_InfoExtra $infoExtra
     * @return \StructType\JP_Flight
     */
    public function setInfoExtra(\StructType\JP_InfoExtra $infoExtra = null)
    {
        $this->InfoExtra = $infoExtra;
        return $this;
    }
    /**
     * Get OptionalFares value
     * @return \StructType\JP_OptionalFares|null
     */
    public function getOptionalFares()
    {
        return $this->OptionalFares;
    }
    /**
     * Set OptionalFares value
     * @param \StructType\JP_OptionalFares $optionalFares
     * @return \StructType\JP_Flight
     */
    public function setOptionalFares(\StructType\JP_OptionalFares $optionalFares = null)
    {
        $this->OptionalFares = $optionalFares;
        return $this;
    }
    /**
     * Get FareType value
     * @return string|null
     */
    public function getFareType()
    {
        return $this->FareType;
    }
    /**
     * Set FareType value
     * @param string $fareType
     * @return \StructType\JP_Flight
     */
    public function setFareType($fareType = null)
    {
        // validation for constraint: string
        if (!is_null($fareType) && !is_string($fareType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fareType)), __LINE__);
        }
        $this->FareType = $fareType;
        return $this;
    }
    /**
     * Get AvailableSeats value
     * @return int|null
     */
    public function getAvailableSeats()
    {
        return $this->AvailableSeats;
    }
    /**
     * Set AvailableSeats value
     * @param int $availableSeats
     * @return \StructType\JP_Flight
     */
    public function setAvailableSeats($availableSeats = null)
    {
        // validation for constraint: int
        if (!is_null($availableSeats) && !is_numeric($availableSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($availableSeats)), __LINE__);
        }
        $this->AvailableSeats = $availableSeats;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \StructType\JP_Flight
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Direction value
     * @return string|null
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @param string $direction
     * @return \StructType\JP_Flight
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: string
        if (!is_null($direction) && !is_string($direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($direction)), __LINE__);
        }
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get LowCost value
     * @return bool|null
     */
    public function getLowCost()
    {
        return $this->LowCost;
    }
    /**
     * Set LowCost value
     * @param bool $lowCost
     * @return \StructType\JP_Flight
     */
    public function setLowCost($lowCost = null)
    {
        // validation for constraint: boolean
        if (!is_null($lowCost) && !is_bool($lowCost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($lowCost)), __LINE__);
        }
        $this->LowCost = $lowCost;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_Flight
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_AvailStatus::valueIsValid()
     * @uses \EnumType\JP_AvailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_Flight
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_AvailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\JP_AvailStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ICode value
     * @return string|null
     */
    public function getICode()
    {
        return $this->ICode;
    }
    /**
     * Set ICode value
     * @param string $iCode
     * @return \StructType\JP_Flight
     */
    public function setICode($iCode = null)
    {
        // validation for constraint: string
        if (!is_null($iCode) && !is_string($iCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iCode)), __LINE__);
        }
        $this->ICode = $iCode;
        return $this;
    }
    /**
     * Get SearchMore value
     * @return bool|null
     */
    public function getSearchMore()
    {
        return $this->SearchMore;
    }
    /**
     * Set SearchMore value
     * @param bool $searchMore
     * @return \StructType\JP_Flight
     */
    public function setSearchMore($searchMore = null)
    {
        // validation for constraint: boolean
        if (!is_null($searchMore) && !is_bool($searchMore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($searchMore)), __LINE__);
        }
        $this->SearchMore = $searchMore;
        return $this;
    }
    /**
     * Get Order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\JP_Flight
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !is_numeric($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param string $source
     * @return \StructType\JP_Flight
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($source)), __LINE__);
        }
        $this->Source = $source;
        return $this;
    }
    /**
     * Get BrandedCode value
     * @return string|null
     */
    public function getBrandedCode()
    {
        return $this->BrandedCode;
    }
    /**
     * Set BrandedCode value
     * @param string $brandedCode
     * @return \StructType\JP_Flight
     */
    public function setBrandedCode($brandedCode = null)
    {
        // validation for constraint: string
        if (!is_null($brandedCode) && !is_string($brandedCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brandedCode)), __LINE__);
        }
        $this->BrandedCode = $brandedCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_Flight
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
