<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CustomerChannels StructType
 * @subpackage Structs
 */
class JP_CustomerChannels extends AbstractStructBase
{
    /**
     * The Channel
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_CustomerCodeElement[]
     */
    public $Channel;
    /**
     * The DefaultCode
     * @var string
     */
    public $DefaultCode;
    /**
     * Constructor method for JP_CustomerChannels
     * @uses JP_CustomerChannels::setChannel()
     * @uses JP_CustomerChannels::setDefaultCode()
     * @param \StructType\JP_CustomerCodeElement[] $channel
     * @param string $defaultCode
     */
    public function __construct(array $channel = array(), $defaultCode = null)
    {
        $this
            ->setChannel($channel)
            ->setDefaultCode($defaultCode);
    }
    /**
     * Get Channel value
     * @return \StructType\JP_CustomerCodeElement[]|null
     */
    public function getChannel()
    {
        return $this->Channel;
    }
    /**
     * Set Channel value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CustomerCodeElement[] $channel
     * @return \StructType\JP_CustomerChannels
     */
    public function setChannel(array $channel = array())
    {
        foreach ($channel as $jP_CustomerChannelsChannelItem) {
            // validation for constraint: itemType
            if (!$jP_CustomerChannelsChannelItem instanceof \StructType\JP_CustomerCodeElement) {
                throw new \InvalidArgumentException(sprintf('The Channel property can only contain items of \StructType\JP_CustomerCodeElement, "%s" given', is_object($jP_CustomerChannelsChannelItem) ? get_class($jP_CustomerChannelsChannelItem) : gettype($jP_CustomerChannelsChannelItem)), __LINE__);
            }
        }
        $this->Channel = $channel;
        return $this;
    }
    /**
     * Add item to Channel value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CustomerCodeElement $item
     * @return \StructType\JP_CustomerChannels
     */
    public function addToChannel(\StructType\JP_CustomerCodeElement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_CustomerCodeElement) {
            throw new \InvalidArgumentException(sprintf('The Channel property can only contain items of \StructType\JP_CustomerCodeElement, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Channel[] = $item;
        return $this;
    }
    /**
     * Get DefaultCode value
     * @return string|null
     */
    public function getDefaultCode()
    {
        return $this->DefaultCode;
    }
    /**
     * Set DefaultCode value
     * @param string $defaultCode
     * @return \StructType\JP_CustomerChannels
     */
    public function setDefaultCode($defaultCode = null)
    {
        // validation for constraint: string
        if (!is_null($defaultCode) && !is_string($defaultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($defaultCode)), __LINE__);
        }
        $this->DefaultCode = $defaultCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_CustomerChannels
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
