<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CruiseCabin StructType
 * @subpackage Structs
 */
class JP_CruiseCabin extends AbstractStructBase
{
    /**
     * The Capacity
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Capacity;
    /**
     * The Images
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString1
     */
    public $Images;
    /**
     * The Deck
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CruiseDeck
     */
    public $Deck;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Beds
     * @var int
     */
    public $Beds;
    /**
     * The CabinNumber
     * @var string
     */
    public $CabinNumber;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * Constructor method for JP_CruiseCabin
     * @uses JP_CruiseCabin::setCapacity()
     * @uses JP_CruiseCabin::setImages()
     * @uses JP_CruiseCabin::setDeck()
     * @uses JP_CruiseCabin::setCode()
     * @uses JP_CruiseCabin::setBeds()
     * @uses JP_CruiseCabin::setCabinNumber()
     * @uses JP_CruiseCabin::setRatePlanCode()
     * @param int $capacity
     * @param \ArrayType\ArrayOfString1 $images
     * @param \StructType\JP_CruiseDeck $deck
     * @param string $code
     * @param int $beds
     * @param string $cabinNumber
     * @param string $ratePlanCode
     */
    public function __construct($capacity = null, \ArrayType\ArrayOfString1 $images = null, \StructType\JP_CruiseDeck $deck = null, $code = null, $beds = null, $cabinNumber = null, $ratePlanCode = null)
    {
        $this
            ->setCapacity($capacity)
            ->setImages($images)
            ->setDeck($deck)
            ->setCode($code)
            ->setBeds($beds)
            ->setCabinNumber($cabinNumber)
            ->setRatePlanCode($ratePlanCode);
    }
    /**
     * Get Capacity value
     * @return int
     */
    public function getCapacity()
    {
        return $this->Capacity;
    }
    /**
     * Set Capacity value
     * @param int $capacity
     * @return \StructType\JP_CruiseCabin
     */
    public function setCapacity($capacity = null)
    {
        // validation for constraint: int
        if (!is_null($capacity) && !is_numeric($capacity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($capacity)), __LINE__);
        }
        $this->Capacity = $capacity;
        return $this;
    }
    /**
     * Get Images value
     * @return \ArrayType\ArrayOfString1|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * Set Images value
     * @param \ArrayType\ArrayOfString1 $images
     * @return \StructType\JP_CruiseCabin
     */
    public function setImages(\ArrayType\ArrayOfString1 $images = null)
    {
        $this->Images = $images;
        return $this;
    }
    /**
     * Get Deck value
     * @return \StructType\JP_CruiseDeck|null
     */
    public function getDeck()
    {
        return $this->Deck;
    }
    /**
     * Set Deck value
     * @param \StructType\JP_CruiseDeck $deck
     * @return \StructType\JP_CruiseCabin
     */
    public function setDeck(\StructType\JP_CruiseDeck $deck = null)
    {
        $this->Deck = $deck;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_CruiseCabin
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Beds value
     * @return int|null
     */
    public function getBeds()
    {
        return $this->Beds;
    }
    /**
     * Set Beds value
     * @param int $beds
     * @return \StructType\JP_CruiseCabin
     */
    public function setBeds($beds = null)
    {
        // validation for constraint: int
        if (!is_null($beds) && !is_numeric($beds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($beds)), __LINE__);
        }
        $this->Beds = $beds;
        return $this;
    }
    /**
     * Get CabinNumber value
     * @return string|null
     */
    public function getCabinNumber()
    {
        return $this->CabinNumber;
    }
    /**
     * Set CabinNumber value
     * @param string $cabinNumber
     * @return \StructType\JP_CruiseCabin
     */
    public function setCabinNumber($cabinNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cabinNumber) && !is_string($cabinNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cabinNumber)), __LINE__);
        }
        $this->CabinNumber = $cabinNumber;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_CruiseCabin
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_CruiseCabin
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
