<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_OccupanciesRules StructType
 * @subpackage Structs
 */
class JPSOAP_OccupanciesRules extends JPSOAP_Occupancies
{
    /**
     * The MinPaxes
     * @var int
     */
    public $MinPaxes;
    /**
     * The MaxPaxes
     * @var int
     */
    public $MaxPaxes;
    /**
     * The Infants
     * @var bool
     */
    public $Infants;
    /**
     * Constructor method for JPSOAP_OccupanciesRules
     * @uses JPSOAP_OccupanciesRules::setMinPaxes()
     * @uses JPSOAP_OccupanciesRules::setMaxPaxes()
     * @uses JPSOAP_OccupanciesRules::setInfants()
     * @param int $minPaxes
     * @param int $maxPaxes
     * @param bool $infants
     */
    public function __construct($minPaxes = null, $maxPaxes = null, $infants = null)
    {
        $this
            ->setMinPaxes($minPaxes)
            ->setMaxPaxes($maxPaxes)
            ->setInfants($infants);
    }
    /**
     * Get MinPaxes value
     * @return int|null
     */
    public function getMinPaxes()
    {
        return $this->MinPaxes;
    }
    /**
     * Set MinPaxes value
     * @param int $minPaxes
     * @return \StructType\JPSOAP_OccupanciesRules
     */
    public function setMinPaxes($minPaxes = null)
    {
        // validation for constraint: int
        if (!is_null($minPaxes) && !is_numeric($minPaxes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minPaxes)), __LINE__);
        }
        $this->MinPaxes = $minPaxes;
        return $this;
    }
    /**
     * Get MaxPaxes value
     * @return int|null
     */
    public function getMaxPaxes()
    {
        return $this->MaxPaxes;
    }
    /**
     * Set MaxPaxes value
     * @param int $maxPaxes
     * @return \StructType\JPSOAP_OccupanciesRules
     */
    public function setMaxPaxes($maxPaxes = null)
    {
        // validation for constraint: int
        if (!is_null($maxPaxes) && !is_numeric($maxPaxes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxPaxes)), __LINE__);
        }
        $this->MaxPaxes = $maxPaxes;
        return $this;
    }
    /**
     * Get Infants value
     * @return bool|null
     */
    public function getInfants()
    {
        return $this->Infants;
    }
    /**
     * Set Infants value
     * @param bool $infants
     * @return \StructType\JPSOAP_OccupanciesRules
     */
    public function setInfants($infants = null)
    {
        // validation for constraint: boolean
        if (!is_null($infants) && !is_bool($infants)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($infants)), __LINE__);
        }
        $this->Infants = $infants;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JPSOAP_OccupanciesRules
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
