<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_Allotment StructType
 * @subpackage Structs
 */
class JPSOAP_Allotment extends AbstractStructBase
{
    /**
     * The From
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $From;
    /**
     * The To
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $To;
    /**
     * The Available
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Available;
    /**
     * The LastUpdated
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $LastUpdated;
    /**
     * Constructor method for JPSOAP_Allotment
     * @uses JPSOAP_Allotment::setFrom()
     * @uses JPSOAP_Allotment::setTo()
     * @uses JPSOAP_Allotment::setAvailable()
     * @uses JPSOAP_Allotment::setLastUpdated()
     * @param string $from
     * @param string $to
     * @param int $available
     * @param string $lastUpdated
     */
    public function __construct($from = null, $to = null, $available = null, $lastUpdated = null)
    {
        $this
            ->setFrom($from)
            ->setTo($to)
            ->setAvailable($available)
            ->setLastUpdated($lastUpdated);
    }
    /**
     * Get From value
     * @return string
     */
    public function getFrom()
    {
        return $this->From;
    }
    /**
     * Set From value
     * @param string $from
     * @return \StructType\JPSOAP_Allotment
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($from)), __LINE__);
        }
        $this->From = $from;
        return $this;
    }
    /**
     * Get To value
     * @return string
     */
    public function getTo()
    {
        return $this->To;
    }
    /**
     * Set To value
     * @param string $to
     * @return \StructType\JPSOAP_Allotment
     */
    public function setTo($to = null)
    {
        // validation for constraint: string
        if (!is_null($to) && !is_string($to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($to)), __LINE__);
        }
        $this->To = $to;
        return $this;
    }
    /**
     * Get Available value
     * @return int
     */
    public function getAvailable()
    {
        return $this->Available;
    }
    /**
     * Set Available value
     * @param int $available
     * @return \StructType\JPSOAP_Allotment
     */
    public function setAvailable($available = null)
    {
        // validation for constraint: int
        if (!is_null($available) && !is_numeric($available)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($available)), __LINE__);
        }
        $this->Available = $available;
        return $this;
    }
    /**
     * Get LastUpdated value
     * @return string
     */
    public function getLastUpdated()
    {
        return $this->LastUpdated;
    }
    /**
     * Set LastUpdated value
     * @param string $lastUpdated
     * @return \StructType\JPSOAP_Allotment
     */
    public function setLastUpdated($lastUpdated = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdated) && !is_string($lastUpdated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdated)), __LINE__);
        }
        $this->LastUpdated = $lastUpdated;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JPSOAP_Allotment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
