<?php

namespace EnumType;

/**
 * This class stands for JP_ItemStatus EnumType
 * @subpackage Enumerations
 */
class JP_ItemStatus
{
    /**
     * Constant for value 'OK'
     * @return string 'OK'
     */
    const VALUE_OK = 'OK';
    /**
     * Constant for value 'AV'
     * @return string 'AV'
     */
    const VALUE_AV = 'AV';
    /**
     * Constant for value 'RQ'
     * @return string 'RQ'
     */
    const VALUE_RQ = 'RQ';
    /**
     * Constant for value 'CA'
     * @return string 'CA'
     */
    const VALUE_CA = 'CA';
    /**
     * Constant for value 'SO'
     * @return string 'SO'
     */
    const VALUE_SO = 'SO';
    /**
     * Constant for value 'RP'
     * @return string 'RP'
     */
    const VALUE_RP = 'RP';
    /**
     * Constant for value 'UN'
     * @return string 'UN'
     */
    const VALUE_UN = 'UN';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OK
     * @uses self::VALUE_AV
     * @uses self::VALUE_RQ
     * @uses self::VALUE_CA
     * @uses self::VALUE_SO
     * @uses self::VALUE_RP
     * @uses self::VALUE_UN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OK,
            self::VALUE_AV,
            self::VALUE_RQ,
            self::VALUE_CA,
            self::VALUE_SO,
            self::VALUE_RP,
            self::VALUE_UN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
