<?php

namespace EnumType;

/**
 * This class stands for JP_GuideType EnumType
 * @subpackage Enumerations
 */
class JP_GuideType
{
    /**
     * Constant for value 'SERVICE'
     * @return string 'SERVICE'
     */
    const VALUE_SERVICE = 'SERVICE';
    /**
     * Constant for value 'HOTEL'
     * @return string 'HOTEL'
     */
    const VALUE_HOTEL = 'HOTEL';
    /**
     * Constant for value 'AIRPORT'
     * @return string 'AIRPORT'
     */
    const VALUE_AIRPORT = 'AIRPORT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SERVICE
     * @uses self::VALUE_HOTEL
     * @uses self::VALUE_AIRPORT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SERVICE,
            self::VALUE_HOTEL,
            self::VALUE_AIRPORT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
