<?php

namespace EnumType;

/**
 * This class stands for JP_GenericCatalogueType EnumType
 * @subpackage Enumerations
 */
class JP_GenericCatalogueType
{
    /**
     * Constant for value 'CURRENCY'
     * @return string 'CURRENCY'
     */
    const VALUE_CURRENCY = 'CURRENCY';
    /**
     * Constant for value 'CURRENCYCONVERTER'
     * @return string 'CURRENCYCONVERTER'
     */
    const VALUE_CURRENCYCONVERTER = 'CURRENCYCONVERTER';
    /**
     * Constant for value 'FAMILYDISCOUNTS'
     * @return string 'FAMILYDISCOUNTS'
     */
    const VALUE_FAMILYDISCOUNTS = 'FAMILYDISCOUNTS';
    /**
     * Constant for value 'DOCTYPE'
     * @return string 'DOCTYPE'
     */
    const VALUE_DOCTYPE = 'DOCTYPE';
    /**
     * Constant for value 'CHANNEL'
     * @return string 'CHANNEL'
     */
    const VALUE_CHANNEL = 'CHANNEL';
    /**
     * Constant for value 'LANGUAGES'
     * @return string 'LANGUAGES'
     */
    const VALUE_LANGUAGES = 'LANGUAGES';
    /**
     * Constant for value 'AGENCIES'
     * @return string 'AGENCIES'
     */
    const VALUE_AGENCIES = 'AGENCIES';
    /**
     * Constant for value 'COUNTRIES'
     * @return string 'COUNTRIES'
     */
    const VALUE_COUNTRIES = 'COUNTRIES';
    /**
     * Constant for value 'MESSAGES'
     * @return string 'MESSAGES'
     */
    const VALUE_MESSAGES = 'MESSAGES';
    /**
     * Constant for value 'OBSERVATIONS'
     * @return string 'OBSERVATIONS'
     */
    const VALUE_OBSERVATIONS = 'OBSERVATIONS';
    /**
     * Constant for value 'SEARCHZONES'
     * @return string 'SEARCHZONES'
     */
    const VALUE_SEARCHZONES = 'SEARCHZONES';
    /**
     * Constant for value 'CLIENTMODULES'
     * @return string 'CLIENTMODULES'
     */
    const VALUE_CLIENTMODULES = 'CLIENTMODULES';
    /**
     * Constant for value 'SBQUOTATIONS'
     * @return string 'SBQUOTATIONS'
     */
    const VALUE_SBQUOTATIONS = 'SBQUOTATIONS';
    /**
     * Constant for value 'SALESCONTRACTTYPE'
     * @return string 'SALESCONTRACTTYPE'
     */
    const VALUE_SALESCONTRACTTYPE = 'SALESCONTRACTTYPE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CURRENCY
     * @uses self::VALUE_CURRENCYCONVERTER
     * @uses self::VALUE_FAMILYDISCOUNTS
     * @uses self::VALUE_DOCTYPE
     * @uses self::VALUE_CHANNEL
     * @uses self::VALUE_LANGUAGES
     * @uses self::VALUE_AGENCIES
     * @uses self::VALUE_COUNTRIES
     * @uses self::VALUE_MESSAGES
     * @uses self::VALUE_OBSERVATIONS
     * @uses self::VALUE_SEARCHZONES
     * @uses self::VALUE_CLIENTMODULES
     * @uses self::VALUE_SBQUOTATIONS
     * @uses self::VALUE_SALESCONTRACTTYPE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CURRENCY,
            self::VALUE_CURRENCYCONVERTER,
            self::VALUE_FAMILYDISCOUNTS,
            self::VALUE_DOCTYPE,
            self::VALUE_CHANNEL,
            self::VALUE_LANGUAGES,
            self::VALUE_AGENCIES,
            self::VALUE_COUNTRIES,
            self::VALUE_MESSAGES,
            self::VALUE_OBSERVATIONS,
            self::VALUE_SEARCHZONES,
            self::VALUE_CLIENTMODULES,
            self::VALUE_SBQUOTATIONS,
            self::VALUE_SALESCONTRACTTYPE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
