<?php

namespace EnumType;

/**
 * This class stands for JP_BaggageType EnumType
 * @subpackage Enumerations
 */
class JP_BaggageType
{
    /**
     * Constant for value 'handBaggage'
     * @return string 'handBaggage'
     */
    const VALUE_HAND_BAGGAGE = 'handBaggage';
    /**
     * Constant for value 'holdBaggage'
     * @return string 'holdBaggage'
     */
    const VALUE_HOLD_BAGGAGE = 'holdBaggage';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HAND_BAGGAGE
     * @uses self::VALUE_HOLD_BAGGAGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HAND_BAGGAGE,
            self::VALUE_HOLD_BAGGAGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
