<?php

namespace EnumType;

/**
 * This class stands for JPSOAP_RestrictionType EnumType
 * @subpackage Enumerations
 */
class JPSOAP_RestrictionType
{
    /**
     * Constant for value 'Basic'
     * @return string 'Basic'
     */
    const VALUE_BASIC = 'Basic';
    /**
     * Constant for value 'MinimuStay'
     * @return string 'MinimuStay'
     */
    const VALUE_MINIMU_STAY = 'MinimuStay';
    /**
     * Constant for value 'CheckinDates'
     * @return string 'CheckinDates'
     */
    const VALUE_CHECKIN_DATES = 'CheckinDates';
    /**
     * Constant for value 'CheckoutDates'
     * @return string 'CheckoutDates'
     */
    const VALUE_CHECKOUT_DATES = 'CheckoutDates';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BASIC
     * @uses self::VALUE_MINIMU_STAY
     * @uses self::VALUE_CHECKIN_DATES
     * @uses self::VALUE_CHECKOUT_DATES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BASIC,
            self::VALUE_MINIMU_STAY,
            self::VALUE_CHECKIN_DATES,
            self::VALUE_CHECKOUT_DATES,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
