<?php

namespace EnumType;

/**
 * This class stands for JPSOAP_ReleaseTypes EnumType
 * @subpackage Enumerations
 */
class JPSOAP_ReleaseTypes
{
    /**
     * Constant for value 'Fixed'
     * @return string 'Fixed'
     */
    const VALUE_FIXED = 'Fixed';
    /**
     * Constant for value 'Percentage'
     * @return string 'Percentage'
     */
    const VALUE_PERCENTAGE = 'Percentage';
    /**
     * Constant for value 'MaxBookings'
     * @return string 'MaxBookings'
     */
    const VALUE_MAX_BOOKINGS = 'MaxBookings';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FIXED
     * @uses self::VALUE_PERCENTAGE
     * @uses self::VALUE_MAX_BOOKINGS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FIXED,
            self::VALUE_PERCENTAGE,
            self::VALUE_MAX_BOOKINGS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
