<?php

namespace EnumType;

/**
 * This class stands for JPSOAP_PricePerTypes EnumType
 * @subpackage Enumerations
 */
class JPSOAP_PricePerTypes
{
    /**
     * Constant for value 'NightPax'
     * @return string 'NightPax'
     */
    const VALUE_NIGHT_PAX = 'NightPax';
    /**
     * Constant for value 'NightRoom'
     * @return string 'NightRoom'
     */
    const VALUE_NIGHT_ROOM = 'NightRoom';
    /**
     * Constant for value 'NightPaxRoom'
     * @return string 'NightPaxRoom'
     */
    const VALUE_NIGHT_PAX_ROOM = 'NightPaxRoom';
    /**
     * Constant for value 'NightBooking'
     * @return string 'NightBooking'
     */
    const VALUE_NIGHT_BOOKING = 'NightBooking';
    /**
     * Constant for value 'StayPax'
     * @return string 'StayPax'
     */
    const VALUE_STAY_PAX = 'StayPax';
    /**
     * Constant for value 'StayRoom'
     * @return string 'StayRoom'
     */
    const VALUE_STAY_ROOM = 'StayRoom';
    /**
     * Constant for value 'StayPaxRoom'
     * @return string 'StayPaxRoom'
     */
    const VALUE_STAY_PAX_ROOM = 'StayPaxRoom';
    /**
     * Constant for value 'StayBooking'
     * @return string 'StayBooking'
     */
    const VALUE_STAY_BOOKING = 'StayBooking';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NIGHT_PAX
     * @uses self::VALUE_NIGHT_ROOM
     * @uses self::VALUE_NIGHT_PAX_ROOM
     * @uses self::VALUE_NIGHT_BOOKING
     * @uses self::VALUE_STAY_PAX
     * @uses self::VALUE_STAY_ROOM
     * @uses self::VALUE_STAY_PAX_ROOM
     * @uses self::VALUE_STAY_BOOKING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NIGHT_PAX,
            self::VALUE_NIGHT_ROOM,
            self::VALUE_NIGHT_PAX_ROOM,
            self::VALUE_NIGHT_BOOKING,
            self::VALUE_STAY_PAX,
            self::VALUE_STAY_ROOM,
            self::VALUE_STAY_PAX_ROOM,
            self::VALUE_STAY_BOOKING,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
