<?php

namespace EnumType;

/**
 * This class stands for JPSOAP_ApplicationTypeOffer EnumType
 * @subpackage Enumerations
 */
class JPSOAP_ApplicationTypeOffer
{
    /**
     * Constant for value 'Priority'
     * @return string 'Priority'
     */
    const VALUE_PRIORITY = 'Priority';
    /**
     * Constant for value 'BestPrice'
     * @return string 'BestPrice'
     */
    const VALUE_BEST_PRICE = 'BestPrice';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PRIORITY
     * @uses self::VALUE_BEST_PRICE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PRIORITY,
            self::VALUE_BEST_PRICE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
