<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_Car ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_Car extends AbstractStructArrayBase
{
    /**
     * The Rentacar
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Car[]
     */
    public $Rentacar;
    /**
     * Constructor method for ArrayOfJP_Car
     * @uses ArrayOfJP_Car::setRentacar()
     * @param \StructType\JP_Car[] $rentacar
     */
    public function __construct(array $rentacar = array())
    {
        $this
            ->setRentacar($rentacar);
    }
    /**
     * Get Rentacar value
     * @return \StructType\JP_Car[]|null
     */
    public function getRentacar()
    {
        return $this->Rentacar;
    }
    /**
     * Set Rentacar value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Car[] $rentacar
     * @return \ArrayType\ArrayOfJP_Car
     */
    public function setRentacar(array $rentacar = array())
    {
        foreach ($rentacar as $arrayOfJP_CarRentacarItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_CarRentacarItem instanceof \StructType\JP_Car) {
                throw new \InvalidArgumentException(sprintf('The Rentacar property can only contain items of \StructType\JP_Car, "%s" given', is_object($arrayOfJP_CarRentacarItem) ? get_class($arrayOfJP_CarRentacarItem) : gettype($arrayOfJP_CarRentacarItem)), __LINE__);
            }
        }
        $this->Rentacar = $rentacar;
        return $this;
    }
    /**
     * Add item to Rentacar value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Car $item
     * @return \ArrayType\ArrayOfJP_Car
     */
    public function addToRentacar(\StructType\JP_Car $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Car) {
            throw new \InvalidArgumentException(sprintf('The Rentacar property can only contain items of \StructType\JP_Car, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Rentacar[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_Car|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_Car|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_Car|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_Car|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_Car|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Rentacar
     */
    public function getAttributeName()
    {
        return 'Rentacar';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_Car
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
