<?php

namespace Liberty\Service\Emisor\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for factura StructType
 * @subpackage Structs
 */
class Factura extends AbstractStructBase
{
    /**
     * The fechaFactura
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $fechaFactura;
    /**
     * The nombreEmisorFactura
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nombreEmisorFactura;
    /**
     * The numeroFactura
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numeroFactura;
    /**
     * The rutDvEmisorFactura
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rutDvEmisorFactura;
    /**
     * The rutEmisorFactura
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $rutEmisorFactura;
    /**
     * Constructor method for factura
     * @uses Factura::setFechaFactura()
     * @uses Factura::setNombreEmisorFactura()
     * @uses Factura::setNumeroFactura()
     * @uses Factura::setRutDvEmisorFactura()
     * @uses Factura::setRutEmisorFactura()
     * @param int $fechaFactura
     * @param string $nombreEmisorFactura
     * @param int $numeroFactura
     * @param string $rutDvEmisorFactura
     * @param int $rutEmisorFactura
     */
    public function __construct($fechaFactura = null, $nombreEmisorFactura = null, $numeroFactura = null, $rutDvEmisorFactura = null, $rutEmisorFactura = null)
    {
        $this
            ->setFechaFactura($fechaFactura)
            ->setNombreEmisorFactura($nombreEmisorFactura)
            ->setNumeroFactura($numeroFactura)
            ->setRutDvEmisorFactura($rutDvEmisorFactura)
            ->setRutEmisorFactura($rutEmisorFactura);
    }
    /**
     * Get fechaFactura value
     * @return int|null
     */
    public function getFechaFactura()
    {
        return $this->fechaFactura;
    }
    /**
     * Set fechaFactura value
     * @param int $fechaFactura
     * @return \Liberty\Service\Emisor\StructType\Factura
     */
    public function setFechaFactura($fechaFactura = null)
    {
        // validation for constraint: int
        if (!is_null($fechaFactura) && !is_numeric($fechaFactura)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fechaFactura)), __LINE__);
        }
        $this->fechaFactura = $fechaFactura;
        return $this;
    }
    /**
     * Get nombreEmisorFactura value
     * @return string|null
     */
    public function getNombreEmisorFactura()
    {
        return $this->nombreEmisorFactura;
    }
    /**
     * Set nombreEmisorFactura value
     * @param string $nombreEmisorFactura
     * @return \Liberty\Service\Emisor\StructType\Factura
     */
    public function setNombreEmisorFactura($nombreEmisorFactura = null)
    {
        // validation for constraint: string
        if (!is_null($nombreEmisorFactura) && !is_string($nombreEmisorFactura)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nombreEmisorFactura)), __LINE__);
        }
        $this->nombreEmisorFactura = $nombreEmisorFactura;
        return $this;
    }
    /**
     * Get numeroFactura value
     * @return int|null
     */
    public function getNumeroFactura()
    {
        return $this->numeroFactura;
    }
    /**
     * Set numeroFactura value
     * @param int $numeroFactura
     * @return \Liberty\Service\Emisor\StructType\Factura
     */
    public function setNumeroFactura($numeroFactura = null)
    {
        // validation for constraint: int
        if (!is_null($numeroFactura) && !is_numeric($numeroFactura)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numeroFactura)), __LINE__);
        }
        $this->numeroFactura = $numeroFactura;
        return $this;
    }
    /**
     * Get rutDvEmisorFactura value
     * @return string|null
     */
    public function getRutDvEmisorFactura()
    {
        return $this->rutDvEmisorFactura;
    }
    /**
     * Set rutDvEmisorFactura value
     * @param string $rutDvEmisorFactura
     * @return \Liberty\Service\Emisor\StructType\Factura
     */
    public function setRutDvEmisorFactura($rutDvEmisorFactura = null)
    {
        // validation for constraint: string
        if (!is_null($rutDvEmisorFactura) && !is_string($rutDvEmisorFactura)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rutDvEmisorFactura)), __LINE__);
        }
        $this->rutDvEmisorFactura = $rutDvEmisorFactura;
        return $this;
    }
    /**
     * Get rutEmisorFactura value
     * @return int|null
     */
    public function getRutEmisorFactura()
    {
        return $this->rutEmisorFactura;
    }
    /**
     * Set rutEmisorFactura value
     * @param int $rutEmisorFactura
     * @return \Liberty\Service\Emisor\StructType\Factura
     */
    public function setRutEmisorFactura($rutEmisorFactura = null)
    {
        // validation for constraint: int
        if (!is_null($rutEmisorFactura) && !is_numeric($rutEmisorFactura)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rutEmisorFactura)), __LINE__);
        }
        $this->rutEmisorFactura = $rutEmisorFactura;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Liberty\Service\Emisor\StructType\Factura
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
