<?php

namespace Liberty\Service\Emisor\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for opcionales StructType
 * @subpackage Structs
 */
class Opcionales extends AbstractStructBase
{
    /**
     * The entry
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Liberty\Service\Emisor\StructType\Entry[]
     */
    public $entry;
    /**
     * Constructor method for opcionales
     * @uses Opcionales::setEntry()
     * @param \Liberty\Service\Emisor\StructType\Entry[] $entry
     */
    public function __construct(array $entry = array())
    {
        $this
            ->setEntry($entry);
    }
    /**
     * Get entry value
     * @return \Liberty\Service\Emisor\StructType\Entry[]|null
     */
    public function getEntry()
    {
        return $this->entry;
    }
    /**
     * Set entry value
     * @throws \InvalidArgumentException
     * @param \Liberty\Service\Emisor\StructType\Entry[] $entry
     * @return \Liberty\Service\Emisor\StructType\Opcionales
     */
    public function setEntry(array $entry = array())
    {
        foreach ($entry as $opcionalesEntryItem) {
            // validation for constraint: itemType
            if (!$opcionalesEntryItem instanceof \Liberty\Service\Emisor\StructType\Entry) {
                throw new \InvalidArgumentException(sprintf('The entry property can only contain items of \Liberty\Service\Emisor\StructType\Entry, "%s" given', is_object($opcionalesEntryItem) ? get_class($opcionalesEntryItem) : gettype($opcionalesEntryItem)), __LINE__);
            }
        }
        $this->entry = $entry;
        return $this;
    }
    /**
     * Add item to entry value
     * @throws \InvalidArgumentException
     * @param \Liberty\Service\Emisor\StructType\Entry $item
     * @return \Liberty\Service\Emisor\StructType\Opcionales
     */
    public function addToEntry(\Liberty\Service\Emisor\StructType\Entry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Liberty\Service\Emisor\StructType\Entry) {
            throw new \InvalidArgumentException(sprintf('The entry property can only contain items of \Liberty\Service\Emisor\StructType\Entry, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->entry[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Liberty\Service\Emisor\StructType\Opcionales
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
