<?php

namespace Liberty\Service\Emisor;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'emitir' => '\\Liberty\\Service\\Emisor\\StructType\\Emitir',
            'emisorRequest' => '\\Liberty\\Service\\Emisor\\StructType\\EmisorRequest',
            'opcionales' => '\\Liberty\\Service\\Emisor\\StructType\\Opcionales',
            'entry' => '\\Liberty\\Service\\Emisor\\StructType\\Entry',
            'alternativa' => '\\Liberty\\Service\\Emisor\\StructType\\Alternativa',
            'asegurado' => '\\Liberty\\Service\\Emisor\\StructType\\Asegurado',
            'conductor' => '\\Liberty\\Service\\Emisor\\StructType\\Conductor',
            'contratante' => '\\Liberty\\Service\\Emisor\\StructType\\Contratante',
            'planPago' => '\\Liberty\\Service\\Emisor\\StructType\\PlanPago',
            'avisoVencimiento' => '\\Liberty\\Service\\Emisor\\StructType\\AvisoVencimiento',
            'cuponera' => '\\Liberty\\Service\\Emisor\\StructType\\Cuponera',
            'cuentaCorrientePac' => '\\Liberty\\Service\\Emisor\\StructType\\CuentaCorrientePac',
            'tarjetaCreditoPat' => '\\Liberty\\Service\\Emisor\\StructType\\TarjetaCreditoPat',
            'riesgo' => '\\Liberty\\Service\\Emisor\\StructType\\Riesgo',
            'tipoEmision' => '\\Liberty\\Service\\Emisor\\StructType\\TipoEmision',
            'continuidad' => '\\Liberty\\Service\\Emisor\\StructType\\Continuidad',
            'factura' => '\\Liberty\\Service\\Emisor\\StructType\\Factura',
            'guia' => '\\Liberty\\Service\\Emisor\\StructType\\Guia',
            'inspeccion' => '\\Liberty\\Service\\Emisor\\StructType\\Inspeccion',
            'emitirResponse' => '\\Liberty\\Service\\Emisor\\StructType\\EmitirResponse',
            'emisorResponse' => '\\Liberty\\Service\\Emisor\\StructType\\EmisorResponse',
            'detalleResponse' => '\\Liberty\\Service\\Emisor\\StructType\\DetalleResponse',
            'Exception' => '\\Liberty\\Service\\Emisor\\StructType\\Exception',
        );
    }
}
