<?php

namespace Liberty\Service\Emisor\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for emisorResponse StructType
 * @subpackage Structs
 */
class EmisorResponse extends AbstractStructBase
{
    /**
     * The detalle
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Liberty\Service\Emisor\StructType\DetalleResponse[]
     */
    public $detalle;
    /**
     * The item
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $item;
    /**
     * The numeroCertificado
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numeroCertificado;
    /**
     * The numeroPoliza
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numeroPoliza;
    /**
     * The status
     * @var bool
     */
    public $status;
    /**
     * Constructor method for emisorResponse
     * @uses EmisorResponse::setDetalle()
     * @uses EmisorResponse::setItem()
     * @uses EmisorResponse::setNumeroCertificado()
     * @uses EmisorResponse::setNumeroPoliza()
     * @uses EmisorResponse::setStatus()
     * @param \Liberty\Service\Emisor\StructType\DetalleResponse[] $detalle
     * @param int $item
     * @param int $numeroCertificado
     * @param int $numeroPoliza
     * @param bool $status
     */
    public function __construct(array $detalle = array(), $item = null, $numeroCertificado = null, $numeroPoliza = null, $status = null)
    {
        $this
            ->setDetalle($detalle)
            ->setItem($item)
            ->setNumeroCertificado($numeroCertificado)
            ->setNumeroPoliza($numeroPoliza)
            ->setStatus($status);
    }
    /**
     * Get detalle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Liberty\Service\Emisor\StructType\DetalleResponse[]|null
     */
    public function getDetalle()
    {
        return isset($this->detalle) ? $this->detalle : null;
    }
    /**
     * Set detalle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Liberty\Service\Emisor\StructType\DetalleResponse[] $detalle
     * @return \Liberty\Service\Emisor\StructType\EmisorResponse
     */
    public function setDetalle(array $detalle = array())
    {
        foreach ($detalle as $emisorResponseDetalleItem) {
            // validation for constraint: itemType
            if (!$emisorResponseDetalleItem instanceof \Liberty\Service\Emisor\StructType\DetalleResponse) {
                throw new \InvalidArgumentException(sprintf('The detalle property can only contain items of \Liberty\Service\Emisor\StructType\DetalleResponse, "%s" given', is_object($emisorResponseDetalleItem) ? get_class($emisorResponseDetalleItem) : gettype($emisorResponseDetalleItem)), __LINE__);
            }
        }
        if (is_null($detalle) || (is_array($detalle) && empty($detalle))) {
            unset($this->detalle);
        } else {
            $this->detalle = $detalle;
        }
        return $this;
    }
    /**
     * Add item to detalle value
     * @throws \InvalidArgumentException
     * @param \Liberty\Service\Emisor\StructType\DetalleResponse $item
     * @return \Liberty\Service\Emisor\StructType\EmisorResponse
     */
    public function addToDetalle(\Liberty\Service\Emisor\StructType\DetalleResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Liberty\Service\Emisor\StructType\DetalleResponse) {
            throw new \InvalidArgumentException(sprintf('The detalle property can only contain items of \Liberty\Service\Emisor\StructType\DetalleResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->detalle[] = $item;
        return $this;
    }
    /**
     * Get item value
     * @return int|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param int $item
     * @return \Liberty\Service\Emisor\StructType\EmisorResponse
     */
    public function setItem($item = null)
    {
        // validation for constraint: int
        if (!is_null($item) && !is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($item)), __LINE__);
        }
        $this->item = $item;
        return $this;
    }
    /**
     * Get numeroCertificado value
     * @return int|null
     */
    public function getNumeroCertificado()
    {
        return $this->numeroCertificado;
    }
    /**
     * Set numeroCertificado value
     * @param int $numeroCertificado
     * @return \Liberty\Service\Emisor\StructType\EmisorResponse
     */
    public function setNumeroCertificado($numeroCertificado = null)
    {
        // validation for constraint: int
        if (!is_null($numeroCertificado) && !is_numeric($numeroCertificado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numeroCertificado)), __LINE__);
        }
        $this->numeroCertificado = $numeroCertificado;
        return $this;
    }
    /**
     * Get numeroPoliza value
     * @return int|null
     */
    public function getNumeroPoliza()
    {
        return $this->numeroPoliza;
    }
    /**
     * Set numeroPoliza value
     * @param int $numeroPoliza
     * @return \Liberty\Service\Emisor\StructType\EmisorResponse
     */
    public function setNumeroPoliza($numeroPoliza = null)
    {
        // validation for constraint: int
        if (!is_null($numeroPoliza) && !is_numeric($numeroPoliza)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numeroPoliza)), __LINE__);
        }
        $this->numeroPoliza = $numeroPoliza;
        return $this;
    }
    /**
     * Get status value
     * @return bool|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param bool $status
     * @return \Liberty\Service\Emisor\StructType\EmisorResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: boolean
        if (!is_null($status) && !is_bool($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Liberty\Service\Emisor\StructType\EmisorResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
