<?php

namespace Liberty\Service\Emisor\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for continuidad StructType
 * @subpackage Structs
 */
class Continuidad extends AbstractStructBase
{
    /**
     * The companiaEmisora
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $companiaEmisora;
    /**
     * The deduciblePolizaOrigen
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $deduciblePolizaOrigen;
    /**
     * The numeroPolizaOrigen
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numeroPolizaOrigen;
    /**
     * The observaciones
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $observaciones;
    /**
     * Constructor method for continuidad
     * @uses Continuidad::setCompaniaEmisora()
     * @uses Continuidad::setDeduciblePolizaOrigen()
     * @uses Continuidad::setNumeroPolizaOrigen()
     * @uses Continuidad::setObservaciones()
     * @param int $companiaEmisora
     * @param int $deduciblePolizaOrigen
     * @param int $numeroPolizaOrigen
     * @param string $observaciones
     */
    public function __construct($companiaEmisora = null, $deduciblePolizaOrigen = null, $numeroPolizaOrigen = null, $observaciones = null)
    {
        $this
            ->setCompaniaEmisora($companiaEmisora)
            ->setDeduciblePolizaOrigen($deduciblePolizaOrigen)
            ->setNumeroPolizaOrigen($numeroPolizaOrigen)
            ->setObservaciones($observaciones);
    }
    /**
     * Get companiaEmisora value
     * @return int|null
     */
    public function getCompaniaEmisora()
    {
        return $this->companiaEmisora;
    }
    /**
     * Set companiaEmisora value
     * @param int $companiaEmisora
     * @return \Liberty\Service\Emisor\StructType\Continuidad
     */
    public function setCompaniaEmisora($companiaEmisora = null)
    {
        // validation for constraint: int
        if (!is_null($companiaEmisora) && !is_numeric($companiaEmisora)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($companiaEmisora)), __LINE__);
        }
        $this->companiaEmisora = $companiaEmisora;
        return $this;
    }
    /**
     * Get deduciblePolizaOrigen value
     * @return int|null
     */
    public function getDeduciblePolizaOrigen()
    {
        return $this->deduciblePolizaOrigen;
    }
    /**
     * Set deduciblePolizaOrigen value
     * @param int $deduciblePolizaOrigen
     * @return \Liberty\Service\Emisor\StructType\Continuidad
     */
    public function setDeduciblePolizaOrigen($deduciblePolizaOrigen = null)
    {
        // validation for constraint: int
        if (!is_null($deduciblePolizaOrigen) && !is_numeric($deduciblePolizaOrigen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($deduciblePolizaOrigen)), __LINE__);
        }
        $this->deduciblePolizaOrigen = $deduciblePolizaOrigen;
        return $this;
    }
    /**
     * Get numeroPolizaOrigen value
     * @return int|null
     */
    public function getNumeroPolizaOrigen()
    {
        return $this->numeroPolizaOrigen;
    }
    /**
     * Set numeroPolizaOrigen value
     * @param int $numeroPolizaOrigen
     * @return \Liberty\Service\Emisor\StructType\Continuidad
     */
    public function setNumeroPolizaOrigen($numeroPolizaOrigen = null)
    {
        // validation for constraint: int
        if (!is_null($numeroPolizaOrigen) && !is_numeric($numeroPolizaOrigen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numeroPolizaOrigen)), __LINE__);
        }
        $this->numeroPolizaOrigen = $numeroPolizaOrigen;
        return $this;
    }
    /**
     * Get observaciones value
     * @return string|null
     */
    public function getObservaciones()
    {
        return $this->observaciones;
    }
    /**
     * Set observaciones value
     * @param string $observaciones
     * @return \Liberty\Service\Emisor\StructType\Continuidad
     */
    public function setObservaciones($observaciones = null)
    {
        // validation for constraint: string
        if (!is_null($observaciones) && !is_string($observaciones)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($observaciones)), __LINE__);
        }
        $this->observaciones = $observaciones;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Liberty\Service\Emisor\StructType\Continuidad
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
