<?php

namespace \Liberty\Service;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'cotizador' => '\\\\Liberty\\Service\\StructType\\Cotizador',
            'cotizadorRequestString' => '\\\\Liberty\\Service\\StructType\\CotizadorRequestString',
            'mapValues' => '\\\\Liberty\\Service\\StructType\\MapValues',
            'entry' => '\\\\Liberty\\Service\\StructType\\Entry',
            'cotizadorResponse' => '\\\\Liberty\\Service\\StructType\\CotizadorResponse',
            'cotizadorCabeceraResponse' => '\\\\Liberty\\Service\\StructType\\CotizadorCabeceraResponse',
            'cotizadorDetalleResponse' => '\\\\Liberty\\Service\\StructType\\CotizadorDetalleResponse',
            'mapCoberturas' => '\\\\Liberty\\Service\\StructType\\MapCoberturas',
            'cotizadorDetalleCoberturaResponse' => '\\\\Liberty\\Service\\StructType\\CotizadorDetalleCoberturaResponse',
            'Exception' => '\\\\Liberty\\Service\\StructType\\Exception',
        );
    }
}
