<?php

namespace \Liberty\Service\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cotizador ServiceType
 * @subpackage Services
 */
class Cotizador extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named cotizador
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \\Liberty\Service\StructType\Cotizador $parameters
     * @return \\Liberty\Service\StructType\CotizadorResponse|bool
     */
    public function cotizador(\\Liberty\Service\StructType\Cotizador $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->cotizador($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \\Liberty\Service\StructType\CotizadorResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
