<?php

namespace MG\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateContact StructType
 * @package MG
 * @subpackage Structs
 */
class MGUpdateContact extends AbstractStructBase
{
    /**
     * The WSContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \MG\StructType\MGWSContact
     */
    public $WSContact;
    /**
     * The ProfileUpdateType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ProfileUpdateType;
    /**
     * The ExternalEventIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalEventIDs;
    /**
     * Constructor method for UpdateContact
     * @uses MGUpdateContact::setWSContact()
     * @uses MGUpdateContact::setProfileUpdateType()
     * @uses MGUpdateContact::setExternalEventIDs()
     * @param \MG\StructType\MGWSContact $wSContact
     * @param string $profileUpdateType
     * @param string $externalEventIDs
     */
    public function __construct(\MG\StructType\MGWSContact $wSContact = null, $profileUpdateType = null, $externalEventIDs = null)
    {
        $this
            ->setWSContact($wSContact)
            ->setProfileUpdateType($profileUpdateType)
            ->setExternalEventIDs($externalEventIDs);
    }
    /**
     * Get WSContact value
     * @return \MG\StructType\MGWSContact
     */
    public function getWSContact()
    {
        return $this->WSContact;
    }
    /**
     * Set WSContact value
     * @param \MG\StructType\MGWSContact $wSContact
     * @return \MG\StructType\MGUpdateContact
     */
    public function setWSContact(\MG\StructType\MGWSContact $wSContact = null)
    {
        $this->WSContact = $wSContact;
        return $this;
    }
    /**
     * Get ProfileUpdateType value
     * @return string
     */
    public function getProfileUpdateType()
    {
        return $this->ProfileUpdateType;
    }
    /**
     * Set ProfileUpdateType value
     * @uses \MG\EnumType\MGImportProfileTypeEnum::valueIsValid()
     * @uses \MG\EnumType\MGImportProfileTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $profileUpdateType
     * @return \MG\StructType\MGUpdateContact
     */
    public function setProfileUpdateType($profileUpdateType = null)
    {
        // validation for constraint: enumeration
        if (!\MG\EnumType\MGImportProfileTypeEnum::valueIsValid($profileUpdateType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $profileUpdateType, implode(', ', \MG\EnumType\MGImportProfileTypeEnum::getValidValues())), __LINE__);
        }
        $this->ProfileUpdateType = $profileUpdateType;
        return $this;
    }
    /**
     * Get ExternalEventIDs value
     * @return string|null
     */
    public function getExternalEventIDs()
    {
        return $this->ExternalEventIDs;
    }
    /**
     * Set ExternalEventIDs value
     * @param string $externalEventIDs
     * @return \MG\StructType\MGUpdateContact
     */
    public function setExternalEventIDs($externalEventIDs = null)
    {
        // validation for constraint: string
        if (!is_null($externalEventIDs) && !is_string($externalEventIDs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalEventIDs)), __LINE__);
        }
        $this->ExternalEventIDs = $externalEventIDs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \MG\StructType\MGUpdateContact
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
