<?php

namespace MG\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendTransactionalMessageResponse StructType
 * @package MG
 * @subpackage Structs
 */
class MGSendTransactionalMessageResponse extends AbstractStructBase
{
    /**
     * The SendTransactionalMessageResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SendTransactionalMessageResult;
    /**
     * Constructor method for SendTransactionalMessageResponse
     * @uses MGSendTransactionalMessageResponse::setSendTransactionalMessageResult()
     * @param string $sendTransactionalMessageResult
     */
    public function __construct($sendTransactionalMessageResult = null)
    {
        $this
            ->setSendTransactionalMessageResult($sendTransactionalMessageResult);
    }
    /**
     * Get SendTransactionalMessageResult value
     * @return string
     */
    public function getSendTransactionalMessageResult()
    {
        return $this->SendTransactionalMessageResult;
    }
    /**
     * Set SendTransactionalMessageResult value
     * @uses \MG\EnumType\MGSendTransactionalMessageToContactResult::valueIsValid()
     * @uses \MG\EnumType\MGSendTransactionalMessageToContactResult::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sendTransactionalMessageResult
     * @return \MG\StructType\MGSendTransactionalMessageResponse
     */
    public function setSendTransactionalMessageResult($sendTransactionalMessageResult = null)
    {
        // validation for constraint: enumeration
        if (!\MG\EnumType\MGSendTransactionalMessageToContactResult::valueIsValid($sendTransactionalMessageResult)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sendTransactionalMessageResult, implode(', ', \MG\EnumType\MGSendTransactionalMessageToContactResult::getValidValues())), __LINE__);
        }
        $this->SendTransactionalMessageResult = $sendTransactionalMessageResult;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \MG\StructType\MGSendTransactionalMessageResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
