<?php

namespace MG\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReportImportContactDetail StructType
 * @package MG
 * @subpackage Structs
 */
class MGReportImportContactDetail extends AbstractStructBase
{
    /**
     * The ImportFileID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ImportFileID;
    /**
     * The Page
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Page;
    /**
     * The ImportResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ImportResult;
    /**
     * The WSException
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \MG\StructType\MGWSException
     */
    public $WSException;
    /**
     * Constructor method for ReportImportContactDetail
     * @uses MGReportImportContactDetail::setImportFileID()
     * @uses MGReportImportContactDetail::setPage()
     * @uses MGReportImportContactDetail::setImportResult()
     * @uses MGReportImportContactDetail::setWSException()
     * @param int $importFileID
     * @param int $page
     * @param string $importResult
     * @param \MG\StructType\MGWSException $wSException
     */
    public function __construct($importFileID = null, $page = null, $importResult = null, \MG\StructType\MGWSException $wSException = null)
    {
        $this
            ->setImportFileID($importFileID)
            ->setPage($page)
            ->setImportResult($importResult)
            ->setWSException($wSException);
    }
    /**
     * Get ImportFileID value
     * @return int
     */
    public function getImportFileID()
    {
        return $this->ImportFileID;
    }
    /**
     * Set ImportFileID value
     * @param int $importFileID
     * @return \MG\StructType\MGReportImportContactDetail
     */
    public function setImportFileID($importFileID = null)
    {
        // validation for constraint: int
        if (!is_null($importFileID) && !is_numeric($importFileID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($importFileID)), __LINE__);
        }
        $this->ImportFileID = $importFileID;
        return $this;
    }
    /**
     * Get Page value
     * @return int
     */
    public function getPage()
    {
        return $this->Page;
    }
    /**
     * Set Page value
     * @param int $page
     * @return \MG\StructType\MGReportImportContactDetail
     */
    public function setPage($page = null)
    {
        // validation for constraint: int
        if (!is_null($page) && !is_numeric($page)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($page)), __LINE__);
        }
        $this->Page = $page;
        return $this;
    }
    /**
     * Get ImportResult value
     * @return string
     */
    public function getImportResult()
    {
        return $this->ImportResult;
    }
    /**
     * Set ImportResult value
     * @uses \MG\EnumType\MGWSImportResultEnum::valueIsValid()
     * @uses \MG\EnumType\MGWSImportResultEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $importResult
     * @return \MG\StructType\MGReportImportContactDetail
     */
    public function setImportResult($importResult = null)
    {
        // validation for constraint: enumeration
        if (!\MG\EnumType\MGWSImportResultEnum::valueIsValid($importResult)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $importResult, implode(', ', \MG\EnumType\MGWSImportResultEnum::getValidValues())), __LINE__);
        }
        $this->ImportResult = $importResult;
        return $this;
    }
    /**
     * Get WSException value
     * @return \MG\StructType\MGWSException
     */
    public function getWSException()
    {
        return $this->WSException;
    }
    /**
     * Set WSException value
     * @param \MG\StructType\MGWSException $wSException
     * @return \MG\StructType\MGReportImportContactDetail
     */
    public function setWSException(\MG\StructType\MGWSException $wSException = null)
    {
        $this->WSException = $wSException;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \MG\StructType\MGReportImportContactDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
