<?php

namespace MG\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BulkLoadContactsWithOptions StructType
 * @package MG
 * @subpackage Structs
 */
class MGBulkLoadContactsWithOptions extends AbstractStructBase
{
    /**
     * The ListID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ListID;
    /**
     * The WSImportDirectives
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \MG\StructType\MGWSImportDirectives
     */
    public $WSImportDirectives;
    /**
     * The WSBulkLoadOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \MG\StructType\MGWSBulkLoadOptions
     */
    public $WSBulkLoadOptions;
    /**
     * The fileMappings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \MG\ArrayType\MGArrayOfWSFileMappings
     */
    public $fileMappings;
    /**
     * The ImportFileStream
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ImportFileStream;
    /**
     * Constructor method for BulkLoadContactsWithOptions
     * @uses MGBulkLoadContactsWithOptions::setListID()
     * @uses MGBulkLoadContactsWithOptions::setWSImportDirectives()
     * @uses MGBulkLoadContactsWithOptions::setWSBulkLoadOptions()
     * @uses MGBulkLoadContactsWithOptions::setFileMappings()
     * @uses MGBulkLoadContactsWithOptions::setImportFileStream()
     * @param int $listID
     * @param \MG\StructType\MGWSImportDirectives $wSImportDirectives
     * @param \MG\StructType\MGWSBulkLoadOptions $wSBulkLoadOptions
     * @param \MG\ArrayType\MGArrayOfWSFileMappings $fileMappings
     * @param string $importFileStream
     */
    public function __construct($listID = null, \MG\StructType\MGWSImportDirectives $wSImportDirectives = null, \MG\StructType\MGWSBulkLoadOptions $wSBulkLoadOptions = null, \MG\ArrayType\MGArrayOfWSFileMappings $fileMappings = null, $importFileStream = null)
    {
        $this
            ->setListID($listID)
            ->setWSImportDirectives($wSImportDirectives)
            ->setWSBulkLoadOptions($wSBulkLoadOptions)
            ->setFileMappings($fileMappings)
            ->setImportFileStream($importFileStream);
    }
    /**
     * Get ListID value
     * @return int
     */
    public function getListID()
    {
        return $this->ListID;
    }
    /**
     * Set ListID value
     * @param int $listID
     * @return \MG\StructType\MGBulkLoadContactsWithOptions
     */
    public function setListID($listID = null)
    {
        // validation for constraint: int
        if (!is_null($listID) && !is_numeric($listID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($listID)), __LINE__);
        }
        $this->ListID = $listID;
        return $this;
    }
    /**
     * Get WSImportDirectives value
     * @return \MG\StructType\MGWSImportDirectives
     */
    public function getWSImportDirectives()
    {
        return $this->WSImportDirectives;
    }
    /**
     * Set WSImportDirectives value
     * @param \MG\StructType\MGWSImportDirectives $wSImportDirectives
     * @return \MG\StructType\MGBulkLoadContactsWithOptions
     */
    public function setWSImportDirectives(\MG\StructType\MGWSImportDirectives $wSImportDirectives = null)
    {
        $this->WSImportDirectives = $wSImportDirectives;
        return $this;
    }
    /**
     * Get WSBulkLoadOptions value
     * @return \MG\StructType\MGWSBulkLoadOptions
     */
    public function getWSBulkLoadOptions()
    {
        return $this->WSBulkLoadOptions;
    }
    /**
     * Set WSBulkLoadOptions value
     * @param \MG\StructType\MGWSBulkLoadOptions $wSBulkLoadOptions
     * @return \MG\StructType\MGBulkLoadContactsWithOptions
     */
    public function setWSBulkLoadOptions(\MG\StructType\MGWSBulkLoadOptions $wSBulkLoadOptions = null)
    {
        $this->WSBulkLoadOptions = $wSBulkLoadOptions;
        return $this;
    }
    /**
     * Get fileMappings value
     * @return \MG\ArrayType\MGArrayOfWSFileMappings|null
     */
    public function getFileMappings()
    {
        return $this->fileMappings;
    }
    /**
     * Set fileMappings value
     * @param \MG\ArrayType\MGArrayOfWSFileMappings $fileMappings
     * @return \MG\StructType\MGBulkLoadContactsWithOptions
     */
    public function setFileMappings(\MG\ArrayType\MGArrayOfWSFileMappings $fileMappings = null)
    {
        $this->fileMappings = $fileMappings;
        return $this;
    }
    /**
     * Get ImportFileStream value
     * @return string|null
     */
    public function getImportFileStream()
    {
        return $this->ImportFileStream;
    }
    /**
     * Set ImportFileStream value
     * @param string $importFileStream
     * @return \MG\StructType\MGBulkLoadContactsWithOptions
     */
    public function setImportFileStream($importFileStream = null)
    {
        // validation for constraint: string
        if (!is_null($importFileStream) && !is_string($importFileStream)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($importFileStream)), __LINE__);
        }
        $this->ImportFileStream = $importFileStream;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \MG\StructType\MGBulkLoadContactsWithOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
