<?php

namespace MG\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @package MG
 * @subpackage Services
 */
class MGSend extends AbstractSoapClientBase
{
    /**
     * Sets the WSUser SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \MG\StructType\MGWSUser $wSUser
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWSUser(\MG\StructType\MGWSUser $wSUser, $nameSpace = 'http://webservices.listrak.com/v31/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'WSUser', $wSUser, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named SendTransactionalMessage
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Sends a transactional message to the specified email address.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGSendTransactionalMessage $parameters
     * @return \MG\StructType\MGSendTransactionalMessageResponse|bool
     */
    public function SendTransactionalMessage(\MG\StructType\MGSendTransactionalMessage $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SendTransactionalMessage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendListMessage
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Sends the supplied message to the entire list and returns a newly assigned MsgID for this send request.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGSendListMessage $parameters
     * @return \MG\StructType\MGSendListMessageResponse|bool
     */
    public function SendListMessage(\MG\StructType\MGSendListMessage $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SendListMessage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendListMessageWithProfileFilter
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Sends the supplied message to a list's contacts who match the supplied profile filter and returns a newly assigned MsgID for this send request.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGSendListMessageWithProfileFilter $parameters
     * @return \MG\StructType\MGSendListMessageWithProfileFilterResponse|bool
     */
    public function SendListMessageWithProfileFilter(\MG\StructType\MGSendListMessageWithProfileFilter $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SendListMessageWithProfileFilter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendListMessageTest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Sends the supplied message to a test email address and returns a newly assigned MsgID for this send request.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGSendListMessageTest $parameters
     * @return \MG\StructType\MGSendListMessageTestResponse|bool
     */
    public function SendListMessageTest(\MG\StructType\MGSendListMessageTest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SendListMessageTest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendListMessageReview
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Sends the supplied message to the review group email addresses define for the list and returns a newly assigned MsgID for this send request.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGSendListMessageReview $parameters
     * @return \MG\StructType\MGSendListMessageReviewResponse|bool
     */
    public function SendListMessageReview(\MG\StructType\MGSendListMessageReview $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SendListMessageReview($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendSavedMessage
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Sends a Saved Message to the list it is contained within and returns a newly assigned MsgID for the request.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGSendSavedMessage $parameters
     * @return \MG\StructType\MGSendSavedMessageResponse|bool
     */
    public function SendSavedMessage(\MG\StructType\MGSendSavedMessage $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SendSavedMessage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendSavedMessageTest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Sends a Saved Message to a Test Email Address.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGSendSavedMessageTest $parameters
     * @return \MG\StructType\MGSendSavedMessageTestResponse|bool
     */
    public function SendSavedMessageTest(\MG\StructType\MGSendSavedMessageTest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SendSavedMessageTest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \MG\StructType\MGSendListMessageResponse|\MG\StructType\MGSendListMessageReviewResponse|\MG\StructType\MGSendListMessageTestResponse|\MG\StructType\MGSendListMessageWithProfileFilterResponse|\MG\StructType\MGSendSavedMessageResponse|\MG\StructType\MGSendSavedMessageTestResponse|\MG\StructType\MGSendTransactionalMessageResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
