<?php

namespace MG\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Schedule ServiceType
 * @package MG
 * @subpackage Services
 */
class MGSchedule extends AbstractSoapClientBase
{
    /**
     * Sets the WSUser SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \MG\StructType\MGWSUser $wSUser
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWSUser(\MG\StructType\MGWSUser $wSUser, $nameSpace = 'http://webservices.listrak.com/v31/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'WSUser', $wSUser, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ScheduleSendListMessage
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Schedules the supplied message to be sent at a future time to the entire list and returns a newly assigned MsgID for this send request. All dates and times are relative to the EST time zone.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGScheduleSendListMessage $parameters
     * @return \MG\StructType\MGScheduleSendListMessageResponse|bool
     */
    public function ScheduleSendListMessage(\MG\StructType\MGScheduleSendListMessage $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ScheduleSendListMessage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ScheduleSendListMessageWithProfileFilter
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Schedules the supplied message to be sent at a future time and returns a newly assigned MsgID for this send request. All dates and times are relative to the EST time zone.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGScheduleSendListMessageWithProfileFilter $parameters
     * @return \MG\StructType\MGScheduleSendListMessageWithProfileFilterResponse|bool
     */
    public function ScheduleSendListMessageWithProfileFilter(\MG\StructType\MGScheduleSendListMessageWithProfileFilter $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ScheduleSendListMessageWithProfileFilter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \MG\StructType\MGScheduleSendListMessageResponse|\MG\StructType\MGScheduleSendListMessageWithProfileFilterResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
