<?php

namespace MG\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @package MG
 * @subpackage Services
 */
class MGAdd extends AbstractSoapClientBase
{
    /**
     * Sets the WSUser SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \MG\StructType\MGWSUser $wSUser
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWSUser(\MG\StructType\MGWSUser $wSUser, $nameSpace = 'http://webservices.listrak.com/v31/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'WSUser', $wSUser, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named AddGoogleTrackingDomainsToList
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Adds Google Tracking Domains to the specified list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGAddGoogleTrackingDomainsToList $parameters
     * @return \MG\StructType\MGAddGoogleTrackingDomainsToListResponse|bool
     */
    public function AddGoogleTrackingDomainsToList(\MG\StructType\MGAddGoogleTrackingDomainsToList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AddGoogleTrackingDomainsToList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \MG\StructType\MGAddGoogleTrackingDomainsToListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
