<?php

namespace MG\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSProfileFilter ArrayType
 * @package MG
 * @subpackage Arrays
 */
class MGArrayOfWSProfileFilter extends AbstractStructArrayBase
{
    /**
     * The WSProfileFilter
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \MG\StructType\MGWSProfileFilter[]
     */
    public $WSProfileFilter;
    /**
     * Constructor method for ArrayOfWSProfileFilter
     * @uses MGArrayOfWSProfileFilter::setWSProfileFilter()
     * @param \MG\StructType\MGWSProfileFilter[] $wSProfileFilter
     */
    public function __construct(array $wSProfileFilter = array())
    {
        $this
            ->setWSProfileFilter($wSProfileFilter);
    }
    /**
     * Get WSProfileFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \MG\StructType\MGWSProfileFilter[]|null
     */
    public function getWSProfileFilter()
    {
        return isset($this->WSProfileFilter) ? $this->WSProfileFilter : null;
    }
    /**
     * Set WSProfileFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \MG\StructType\MGWSProfileFilter[] $wSProfileFilter
     * @return \MG\ArrayType\MGArrayOfWSProfileFilter
     */
    public function setWSProfileFilter(array $wSProfileFilter = array())
    {
        foreach ($wSProfileFilter as $arrayOfWSProfileFilterWSProfileFilterItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSProfileFilterWSProfileFilterItem instanceof \MG\StructType\MGWSProfileFilter) {
                throw new \InvalidArgumentException(sprintf('The WSProfileFilter property can only contain items of \MG\StructType\MGWSProfileFilter, "%s" given', is_object($arrayOfWSProfileFilterWSProfileFilterItem) ? get_class($arrayOfWSProfileFilterWSProfileFilterItem) : gettype($arrayOfWSProfileFilterWSProfileFilterItem)), __LINE__);
            }
        }
        if (is_null($wSProfileFilter) || (is_array($wSProfileFilter) && empty($wSProfileFilter))) {
            unset($this->WSProfileFilter);
        } else {
            $this->WSProfileFilter = $wSProfileFilter;
        }
        return $this;
    }
    /**
     * Add item to WSProfileFilter value
     * @throws \InvalidArgumentException
     * @param \MG\StructType\MGWSProfileFilter $item
     * @return \MG\ArrayType\MGArrayOfWSProfileFilter
     */
    public function addToWSProfileFilter(\MG\StructType\MGWSProfileFilter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \MG\StructType\MGWSProfileFilter) {
            throw new \InvalidArgumentException(sprintf('The WSProfileFilter property can only contain items of \MG\StructType\MGWSProfileFilter, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->WSProfileFilter[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \MG\StructType\MGWSProfileFilter|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \MG\StructType\MGWSProfileFilter|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \MG\StructType\MGWSProfileFilter|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \MG\StructType\MGWSProfileFilter|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \MG\StructType\MGWSProfileFilter|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSProfileFilter
     */
    public function getAttributeName()
    {
        return 'WSProfileFilter';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \MG\ArrayType\MGArrayOfWSProfileFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
