<?php

namespace MG\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSConversationActivity ArrayType
 * @package MG
 * @subpackage Arrays
 */
class MGArrayOfWSConversationActivity extends AbstractStructArrayBase
{
    /**
     * The WSConversationActivity
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \MG\StructType\MGWSConversationActivity[]
     */
    public $WSConversationActivity;
    /**
     * Constructor method for ArrayOfWSConversationActivity
     * @uses MGArrayOfWSConversationActivity::setWSConversationActivity()
     * @param \MG\StructType\MGWSConversationActivity[] $wSConversationActivity
     */
    public function __construct(array $wSConversationActivity = array())
    {
        $this
            ->setWSConversationActivity($wSConversationActivity);
    }
    /**
     * Get WSConversationActivity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \MG\StructType\MGWSConversationActivity[]|null
     */
    public function getWSConversationActivity()
    {
        return isset($this->WSConversationActivity) ? $this->WSConversationActivity : null;
    }
    /**
     * Set WSConversationActivity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \MG\StructType\MGWSConversationActivity[] $wSConversationActivity
     * @return \MG\ArrayType\MGArrayOfWSConversationActivity
     */
    public function setWSConversationActivity(array $wSConversationActivity = array())
    {
        foreach ($wSConversationActivity as $arrayOfWSConversationActivityWSConversationActivityItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSConversationActivityWSConversationActivityItem instanceof \MG\StructType\MGWSConversationActivity) {
                throw new \InvalidArgumentException(sprintf('The WSConversationActivity property can only contain items of \MG\StructType\MGWSConversationActivity, "%s" given', is_object($arrayOfWSConversationActivityWSConversationActivityItem) ? get_class($arrayOfWSConversationActivityWSConversationActivityItem) : gettype($arrayOfWSConversationActivityWSConversationActivityItem)), __LINE__);
            }
        }
        if (is_null($wSConversationActivity) || (is_array($wSConversationActivity) && empty($wSConversationActivity))) {
            unset($this->WSConversationActivity);
        } else {
            $this->WSConversationActivity = $wSConversationActivity;
        }
        return $this;
    }
    /**
     * Add item to WSConversationActivity value
     * @throws \InvalidArgumentException
     * @param \MG\StructType\MGWSConversationActivity $item
     * @return \MG\ArrayType\MGArrayOfWSConversationActivity
     */
    public function addToWSConversationActivity(\MG\StructType\MGWSConversationActivity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \MG\StructType\MGWSConversationActivity) {
            throw new \InvalidArgumentException(sprintf('The WSConversationActivity property can only contain items of \MG\StructType\MGWSConversationActivity, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->WSConversationActivity[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \MG\StructType\MGWSConversationActivity|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \MG\StructType\MGWSConversationActivity|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \MG\StructType\MGWSConversationActivity|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \MG\StructType\MGWSConversationActivity|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \MG\StructType\MGWSConversationActivity|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSConversationActivity
     */
    public function getAttributeName()
    {
        return 'WSConversationActivity';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \MG\ArrayType\MGArrayOfWSConversationActivity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
