<?php

namespace MG\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSContactSubscriptionInfo ArrayType
 * @package MG
 * @subpackage Arrays
 */
class MGArrayOfWSContactSubscriptionInfo extends AbstractStructArrayBase
{
    /**
     * The WSContactSubscriptionInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \MG\StructType\MGWSContactSubscriptionInfo[]
     */
    public $WSContactSubscriptionInfo;
    /**
     * Constructor method for ArrayOfWSContactSubscriptionInfo
     * @uses MGArrayOfWSContactSubscriptionInfo::setWSContactSubscriptionInfo()
     * @param \MG\StructType\MGWSContactSubscriptionInfo[] $wSContactSubscriptionInfo
     */
    public function __construct(array $wSContactSubscriptionInfo = array())
    {
        $this
            ->setWSContactSubscriptionInfo($wSContactSubscriptionInfo);
    }
    /**
     * Get WSContactSubscriptionInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \MG\StructType\MGWSContactSubscriptionInfo[]|null
     */
    public function getWSContactSubscriptionInfo()
    {
        return isset($this->WSContactSubscriptionInfo) ? $this->WSContactSubscriptionInfo : null;
    }
    /**
     * Set WSContactSubscriptionInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \MG\StructType\MGWSContactSubscriptionInfo[] $wSContactSubscriptionInfo
     * @return \MG\ArrayType\MGArrayOfWSContactSubscriptionInfo
     */
    public function setWSContactSubscriptionInfo(array $wSContactSubscriptionInfo = array())
    {
        foreach ($wSContactSubscriptionInfo as $arrayOfWSContactSubscriptionInfoWSContactSubscriptionInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSContactSubscriptionInfoWSContactSubscriptionInfoItem instanceof \MG\StructType\MGWSContactSubscriptionInfo) {
                throw new \InvalidArgumentException(sprintf('The WSContactSubscriptionInfo property can only contain items of \MG\StructType\MGWSContactSubscriptionInfo, "%s" given', is_object($arrayOfWSContactSubscriptionInfoWSContactSubscriptionInfoItem) ? get_class($arrayOfWSContactSubscriptionInfoWSContactSubscriptionInfoItem) : gettype($arrayOfWSContactSubscriptionInfoWSContactSubscriptionInfoItem)), __LINE__);
            }
        }
        if (is_null($wSContactSubscriptionInfo) || (is_array($wSContactSubscriptionInfo) && empty($wSContactSubscriptionInfo))) {
            unset($this->WSContactSubscriptionInfo);
        } else {
            $this->WSContactSubscriptionInfo = $wSContactSubscriptionInfo;
        }
        return $this;
    }
    /**
     * Add item to WSContactSubscriptionInfo value
     * @throws \InvalidArgumentException
     * @param \MG\StructType\MGWSContactSubscriptionInfo $item
     * @return \MG\ArrayType\MGArrayOfWSContactSubscriptionInfo
     */
    public function addToWSContactSubscriptionInfo(\MG\StructType\MGWSContactSubscriptionInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \MG\StructType\MGWSContactSubscriptionInfo) {
            throw new \InvalidArgumentException(sprintf('The WSContactSubscriptionInfo property can only contain items of \MG\StructType\MGWSContactSubscriptionInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->WSContactSubscriptionInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \MG\StructType\MGWSContactSubscriptionInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \MG\StructType\MGWSContactSubscriptionInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \MG\StructType\MGWSContactSubscriptionInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \MG\StructType\MGWSContactSubscriptionInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \MG\StructType\MGWSContactSubscriptionInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSContactSubscriptionInfo
     */
    public function getAttributeName()
    {
        return 'WSContactSubscriptionInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \MG\ArrayType\MGArrayOfWSContactSubscriptionInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
