<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://webservices.listrak.com/v31/IntegrationService.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://webservices.listrak.com/v31/IntegrationService.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \MG\MGClassMap::get(),
);
/**
 * Samples for Bulk ServiceType
 */
$bulk = new \MG\ServiceType\MGBulk($options);
$bulk->setSoapHeaderWSUser(new \MG\StructType\MGWSUser());
/**
 * Sample call for BulkLoadContacts operation/method
 */
if ($bulk->BulkLoadContacts(new \MG\StructType\MGBulkLoadContacts()) !== false) {
    print_r($bulk->getResult());
} else {
    print_r($bulk->getLastError());
}
/**
 * Sample call for BulkLoadContactsWithOptions operation/method
 */
if ($bulk->BulkLoadContactsWithOptions(new \MG\StructType\MGBulkLoadContactsWithOptions()) !== false) {
    print_r($bulk->getResult());
} else {
    print_r($bulk->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \MG\ServiceType\MGUpdate($options);
$update->setSoapHeaderWSUser(new \MG\StructType\MGWSUser());
/**
 * Sample call for UpdateSubscribedContactAttribute operation/method
 */
if ($update->UpdateSubscribedContactAttribute(new \MG\StructType\MGUpdateSubscribedContactAttribute()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateSubscribedContactAttributeWithOptions operation/method
 */
if ($update->UpdateSubscribedContactAttributeWithOptions(new \MG\StructType\MGUpdateSubscribedContactAttributeWithOptions()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateContactList operation/method
 */
if ($update->UpdateContactList(new \MG\StructType\MGUpdateContactList()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateProfileHeader operation/method
 */
if ($update->UpdateProfileHeader(new \MG\StructType\MGUpdateProfileHeader()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateProfileAttribute operation/method
 */
if ($update->UpdateProfileAttribute(new \MG\StructType\MGUpdateProfileAttribute()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateContact operation/method
 */
if ($update->UpdateContact(new \MG\StructType\MGUpdateContact()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \MG\ServiceType\MGGet($options);
$get->setSoapHeaderWSUser(new \MG\StructType\MGWSUser());
/**
 * Sample call for GetProcessStatus operation/method
 */
if ($get->GetProcessStatus(new \MG\StructType\MGGetProcessStatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMessageStatus operation/method
 */
if ($get->GetMessageStatus(new \MG\StructType\MGGetMessageStatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLegacyProcessStatus operation/method
 */
if ($get->GetLegacyProcessStatus(new \MG\StructType\MGGetLegacyProcessStatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAccountVmtaCollection operation/method
 */
if ($get->GetAccountVmtaCollection(new \MG\StructType\MGGetAccountVmtaCollection()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetContactList operation/method
 */
if ($get->GetContactList(new \MG\StructType\MGGetContactList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetContactListCollection operation/method
 */
if ($get->GetContactListCollection(new \MG\StructType\MGGetContactListCollection()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProfileHeaderCollection operation/method
 */
if ($get->GetProfileHeaderCollection(new \MG\StructType\MGGetProfileHeaderCollection()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetContact operation/method
 */
if ($get->GetContact(new \MG\StructType\MGGetContact()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetContactByEmailKey operation/method
 */
if ($get->GetContactByEmailKey(new \MG\StructType\MGGetContactByEmailKey()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTransactionalMessageCollection operation/method
 */
if ($get->GetTransactionalMessageCollection(new \MG\StructType\MGGetTransactionalMessageCollection()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMessageAnalyticsInformation operation/method
 */
if ($get->GetMessageAnalyticsInformation(new \MG\StructType\MGGetMessageAnalyticsInformation()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSpamScore operation/method
 */
if ($get->GetSpamScore(new \MG\StructType\MGGetSpamScore()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCampaignCollection operation/method
 */
if ($get->GetCampaignCollection(new \MG\StructType\MGGetCampaignCollection()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCharacterSetCollection operation/method
 */
if ($get->GetCharacterSetCollection(new \MG\StructType\MGGetCharacterSetCollection()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSavedMessageCollection operation/method
 */
if ($get->GetSavedMessageCollection(new \MG\StructType\MGGetSavedMessageCollection()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFilteredListCount operation/method
 */
if ($get->GetFilteredListCount(new \MG\StructType\MGGetFilteredListCount()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSystemIDFromPublicID operation/method
 */
if ($get->GetSystemIDFromPublicID(new \MG\StructType\MGGetSystemIDFromPublicID()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Conductor ServiceType
 */
$conductor = new \MG\ServiceType\MGConductor($options);
$conductor->setSoapHeaderWSUser(new \MG\StructType\MGWSUser());
/**
 * Sample call for ConductorBulkLoadAndTriggerContacts operation/method
 */
if ($conductor->ConductorBulkLoadAndTriggerContacts(new \MG\StructType\MGConductorBulkLoadAndTriggerContacts()) !== false) {
    print_r($conductor->getResult());
} else {
    print_r($conductor->getLastError());
}
/**
 * Sample call for ConductorBulkLoadAndTriggerContactsWithOptions operation/method
 */
if ($conductor->ConductorBulkLoadAndTriggerContactsWithOptions(new \MG\StructType\MGConductorBulkLoadAndTriggerContactsWithOptions()) !== false) {
    print_r($conductor->getResult());
} else {
    print_r($conductor->getLastError());
}
/**
 * Sample call for ConductorGetExternalEvents operation/method
 */
if ($conductor->ConductorGetExternalEvents(new \MG\StructType\MGConductorGetExternalEvents()) !== false) {
    print_r($conductor->getResult());
} else {
    print_r($conductor->getLastError());
}
/**
 * Sample call for ConductorGetConversations operation/method
 */
if ($conductor->ConductorGetConversations(new \MG\StructType\MGConductorGetConversations()) !== false) {
    print_r($conductor->getResult());
} else {
    print_r($conductor->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \MG\ServiceType\MGCreate($options);
$create->setSoapHeaderWSUser(new \MG\StructType\MGWSUser());
/**
 * Sample call for CreateContactList operation/method
 */
if ($create->CreateContactList(new \MG\StructType\MGCreateContactList()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateList operation/method
 */
if ($create->CreateList(new \MG\StructType\MGCreateList()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateProfileHeader operation/method
 */
if ($create->CreateProfileHeader(new \MG\StructType\MGCreateProfileHeader()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateProfileAttribute operation/method
 */
if ($create->CreateProfileAttribute(new \MG\StructType\MGCreateProfileAttribute()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \MG\ServiceType\MGAdd($options);
$add->setSoapHeaderWSUser(new \MG\StructType\MGWSUser());
/**
 * Sample call for AddGoogleTrackingDomainsToList operation/method
 */
if ($add->AddGoogleTrackingDomainsToList(new \MG\StructType\MGAddGoogleTrackingDomainsToList()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \MG\ServiceType\MGDelete($options);
$delete->setSoapHeaderWSUser(new \MG\StructType\MGWSUser());
/**
 * Sample call for DeleteGoogleTrackingDomainsFromList operation/method
 */
if ($delete->DeleteGoogleTrackingDomainsFromList(new \MG\StructType\MGDeleteGoogleTrackingDomainsFromList()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteContactList operation/method
 */
if ($delete->DeleteContactList(new \MG\StructType\MGDeleteContactList()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteProfileHeader operation/method
 */
if ($delete->DeleteProfileHeader(new \MG\StructType\MGDeleteProfileHeader()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteProfileAttribute operation/method
 */
if ($delete->DeleteProfileAttribute(new \MG\StructType\MGDeleteProfileAttribute()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \MG\ServiceType\MGSet($options);
$set->setSoapHeaderWSUser(new \MG\StructType\MGWSUser());
/**
 * Sample call for SetContact operation/method
 */
if ($set->SetContact(new \MG\StructType\MGSetContact()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \MG\ServiceType\MGSend($options);
$send->setSoapHeaderWSUser(new \MG\StructType\MGWSUser());
/**
 * Sample call for SendTransactionalMessage operation/method
 */
if ($send->SendTransactionalMessage(new \MG\StructType\MGSendTransactionalMessage()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendListMessage operation/method
 */
if ($send->SendListMessage(new \MG\StructType\MGSendListMessage()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendListMessageWithProfileFilter operation/method
 */
if ($send->SendListMessageWithProfileFilter(new \MG\StructType\MGSendListMessageWithProfileFilter()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendListMessageTest operation/method
 */
if ($send->SendListMessageTest(new \MG\StructType\MGSendListMessageTest()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendListMessageReview operation/method
 */
if ($send->SendListMessageReview(new \MG\StructType\MGSendListMessageReview()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendSavedMessage operation/method
 */
if ($send->SendSavedMessage(new \MG\StructType\MGSendSavedMessage()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendSavedMessageTest operation/method
 */
if ($send->SendSavedMessageTest(new \MG\StructType\MGSendSavedMessageTest()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Subscribe ServiceType
 */
$subscribe = new \MG\ServiceType\MGSubscribe($options);
$subscribe->setSoapHeaderWSUser(new \MG\StructType\MGWSUser());
/**
 * Sample call for SubscribeFormPassThrough operation/method
 */
if ($subscribe->SubscribeFormPassThrough(new \MG\StructType\MGSubscribeFormPassThrough()) !== false) {
    print_r($subscribe->getResult());
} else {
    print_r($subscribe->getLastError());
}
/**
 * Sample call for SubscribeContact operation/method
 */
if ($subscribe->SubscribeContact(new \MG\StructType\MGSubscribeContact()) !== false) {
    print_r($subscribe->getResult());
} else {
    print_r($subscribe->getLastError());
}
/**
 * Samples for Change ServiceType
 */
$change = new \MG\ServiceType\MGChange($options);
$change->setSoapHeaderWSUser(new \MG\StructType\MGWSUser());
/**
 * Sample call for ChangeContactEmailAddress operation/method
 */
if ($change->ChangeContactEmailAddress(new \MG\StructType\MGChangeContactEmailAddress()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Samples for Unsubscribe ServiceType
 */
$unsubscribe = new \MG\ServiceType\MGUnsubscribe($options);
$unsubscribe->setSoapHeaderWSUser(new \MG\StructType\MGWSUser());
/**
 * Sample call for UnsubscribeContact operation/method
 */
if ($unsubscribe->UnsubscribeContact(new \MG\StructType\MGUnsubscribeContact()) !== false) {
    print_r($unsubscribe->getResult());
} else {
    print_r($unsubscribe->getLastError());
}
/**
 * Samples for Schedule ServiceType
 */
$schedule = new \MG\ServiceType\MGSchedule($options);
$schedule->setSoapHeaderWSUser(new \MG\StructType\MGWSUser());
/**
 * Sample call for ScheduleSendListMessage operation/method
 */
if ($schedule->ScheduleSendListMessage(new \MG\StructType\MGScheduleSendListMessage()) !== false) {
    print_r($schedule->getResult());
} else {
    print_r($schedule->getLastError());
}
/**
 * Sample call for ScheduleSendListMessageWithProfileFilter operation/method
 */
if ($schedule->ScheduleSendListMessageWithProfileFilter(new \MG\StructType\MGScheduleSendListMessageWithProfileFilter()) !== false) {
    print_r($schedule->getResult());
} else {
    print_r($schedule->getLastError());
}
/**
 * Samples for Report ServiceType
 */
$report = new \MG\ServiceType\MGReport($options);
$report->setSoapHeaderWSUser(new \MG\StructType\MGWSUser());
/**
 * Sample call for ReportSubscribedContacts operation/method
 */
if ($report->ReportSubscribedContacts(new \MG\StructType\MGReportSubscribedContacts()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportRangeSubscribedContacts operation/method
 */
if ($report->ReportRangeSubscribedContacts(new \MG\StructType\MGReportRangeSubscribedContacts()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportAdminContactFeedbackLoop operation/method
 */
if ($report->ReportAdminContactFeedbackLoop(new \MG\StructType\MGReportAdminContactFeedbackLoop()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportMessageContactSent operation/method
 */
if ($report->ReportMessageContactSent(new \MG\StructType\MGReportMessageContactSent()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportMessageContactOpen operation/method
 */
if ($report->ReportMessageContactOpen(new \MG\StructType\MGReportMessageContactOpen()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportRangeMessageContactOpen operation/method
 */
if ($report->ReportRangeMessageContactOpen(new \MG\StructType\MGReportRangeMessageContactOpen()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportMessageContactRead operation/method
 */
if ($report->ReportMessageContactRead(new \MG\StructType\MGReportMessageContactRead()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportRangeMessageContactRead operation/method
 */
if ($report->ReportRangeMessageContactRead(new \MG\StructType\MGReportRangeMessageContactRead()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportMessageContactClick operation/method
 */
if ($report->ReportMessageContactClick(new \MG\StructType\MGReportMessageContactClick()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportRangeMessageContactClick operation/method
 */
if ($report->ReportRangeMessageContactClick(new \MG\StructType\MGReportRangeMessageContactClick()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportMessageContactPassalong operation/method
 */
if ($report->ReportMessageContactPassalong(new \MG\StructType\MGReportMessageContactPassalong()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportRangeMessageContactPassalong operation/method
 */
if ($report->ReportRangeMessageContactPassalong(new \MG\StructType\MGReportRangeMessageContactPassalong()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportMessageContactBounces operation/method
 */
if ($report->ReportMessageContactBounces(new \MG\StructType\MGReportMessageContactBounces()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportRangeMessageContactBounces operation/method
 */
if ($report->ReportRangeMessageContactBounces(new \MG\StructType\MGReportRangeMessageContactBounces()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportListMessageActivity operation/method
 */
if ($report->ReportListMessageActivity(new \MG\StructType\MGReportListMessageActivity()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportListMessageDelivery operation/method
 */
if ($report->ReportListMessageDelivery(new \MG\StructType\MGReportListMessageDelivery()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportListContactRemoval operation/method
 */
if ($report->ReportListContactRemoval(new \MG\StructType\MGReportListContactRemoval()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportRangeListContactRemoval operation/method
 */
if ($report->ReportRangeListContactRemoval(new \MG\StructType\MGReportRangeListContactRemoval()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportListContactHygiene operation/method
 */
if ($report->ReportListContactHygiene(new \MG\StructType\MGReportListContactHygiene()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportRangeListContactHygiene operation/method
 */
if ($report->ReportRangeListContactHygiene(new \MG\StructType\MGReportRangeListContactHygiene()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportMessageLinkClick operation/method
 */
if ($report->ReportMessageLinkClick(new \MG\StructType\MGReportMessageLinkClick()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportContactLinkClick operation/method
 */
if ($report->ReportContactLinkClick(new \MG\StructType\MGReportContactLinkClick()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportMessageLocationClick operation/method
 */
if ($report->ReportMessageLocationClick(new \MG\StructType\MGReportMessageLocationClick()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportMessageLocationOpen operation/method
 */
if ($report->ReportMessageLocationOpen(new \MG\StructType\MGReportMessageLocationOpen()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportMessageLocationRead operation/method
 */
if ($report->ReportMessageLocationRead(new \MG\StructType\MGReportMessageLocationRead()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportMessageLocationContactClick operation/method
 */
if ($report->ReportMessageLocationContactClick(new \MG\StructType\MGReportMessageLocationContactClick()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportMessageLocationContactOpen operation/method
 */
if ($report->ReportMessageLocationContactOpen(new \MG\StructType\MGReportMessageLocationContactOpen()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportMessageLocationContactRead operation/method
 */
if ($report->ReportMessageLocationContactRead(new \MG\StructType\MGReportMessageLocationContactRead()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportMessageContactActivity operation/method
 */
if ($report->ReportMessageContactActivity(new \MG\StructType\MGReportMessageContactActivity()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportRangeMessageContactRemoval operation/method
 */
if ($report->ReportRangeMessageContactRemoval(new \MG\StructType\MGReportRangeMessageContactRemoval()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportMessageContactRemoval operation/method
 */
if ($report->ReportMessageContactRemoval(new \MG\StructType\MGReportMessageContactRemoval()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportContactMessageActivity operation/method
 */
if ($report->ReportContactMessageActivity(new \MG\StructType\MGReportContactMessageActivity()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportListImportHistory operation/method
 */
if ($report->ReportListImportHistory(new \MG\StructType\MGReportListImportHistory()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportImportContactDetail operation/method
 */
if ($report->ReportImportContactDetail(new \MG\StructType\MGReportImportContactDetail()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportListConversationActivity operation/method
 */
if ($report->ReportListConversationActivity(new \MG\StructType\MGReportListConversationActivity()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportListConversationDelivery operation/method
 */
if ($report->ReportListConversationDelivery(new \MG\StructType\MGReportListConversationDelivery()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportConversationContactDelivery operation/method
 */
if ($report->ReportConversationContactDelivery(new \MG\StructType\MGReportConversationContactDelivery()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportConversationContactRemoval operation/method
 */
if ($report->ReportConversationContactRemoval(new \MG\StructType\MGReportConversationContactRemoval()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportConversationContactOpen operation/method
 */
if ($report->ReportConversationContactOpen(new \MG\StructType\MGReportConversationContactOpen()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportConversationContactRead operation/method
 */
if ($report->ReportConversationContactRead(new \MG\StructType\MGReportConversationContactRead()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportConversationLinkClick operation/method
 */
if ($report->ReportConversationLinkClick(new \MG\StructType\MGReportConversationLinkClick()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportConversationContactBounce operation/method
 */
if ($report->ReportConversationContactBounce(new \MG\StructType\MGReportConversationContactBounce()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportConversationLocationContactOpen operation/method
 */
if ($report->ReportConversationLocationContactOpen(new \MG\StructType\MGReportConversationLocationContactOpen()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportConversationLocationContactRead operation/method
 */
if ($report->ReportConversationLocationContactRead(new \MG\StructType\MGReportConversationLocationContactRead()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportConversationLocationContactClick operation/method
 */
if ($report->ReportConversationLocationContactClick(new \MG\StructType\MGReportConversationLocationContactClick()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
