<?php

namespace MG\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ScheduleSendListMessageWithProfileFilter StructType
 * @package MG
 * @subpackage Structs
 */
class MGScheduleSendListMessageWithProfileFilter extends AbstractStructBase
{
    /**
     * The WSMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \MG\StructType\MGWSMessage
     */
    public $WSMessage;
    /**
     * The SendDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SendDateTime;
    /**
     * The ProfileFilter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \MG\ArrayType\MGArrayOfWSProfileFilter
     */
    public $ProfileFilter;
    /**
     * Constructor method for ScheduleSendListMessageWithProfileFilter
     * @uses MGScheduleSendListMessageWithProfileFilter::setWSMessage()
     * @uses MGScheduleSendListMessageWithProfileFilter::setSendDateTime()
     * @uses MGScheduleSendListMessageWithProfileFilter::setProfileFilter()
     * @param \MG\StructType\MGWSMessage $wSMessage
     * @param string $sendDateTime
     * @param \MG\ArrayType\MGArrayOfWSProfileFilter $profileFilter
     */
    public function __construct(\MG\StructType\MGWSMessage $wSMessage = null, $sendDateTime = null, \MG\ArrayType\MGArrayOfWSProfileFilter $profileFilter = null)
    {
        $this
            ->setWSMessage($wSMessage)
            ->setSendDateTime($sendDateTime)
            ->setProfileFilter($profileFilter);
    }
    /**
     * Get WSMessage value
     * @return \MG\StructType\MGWSMessage
     */
    public function getWSMessage()
    {
        return $this->WSMessage;
    }
    /**
     * Set WSMessage value
     * @param \MG\StructType\MGWSMessage $wSMessage
     * @return \MG\StructType\MGScheduleSendListMessageWithProfileFilter
     */
    public function setWSMessage(\MG\StructType\MGWSMessage $wSMessage = null)
    {
        $this->WSMessage = $wSMessage;
        return $this;
    }
    /**
     * Get SendDateTime value
     * @return string
     */
    public function getSendDateTime()
    {
        return $this->SendDateTime;
    }
    /**
     * Set SendDateTime value
     * @param string $sendDateTime
     * @return \MG\StructType\MGScheduleSendListMessageWithProfileFilter
     */
    public function setSendDateTime($sendDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($sendDateTime) && !is_string($sendDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sendDateTime)), __LINE__);
        }
        $this->SendDateTime = $sendDateTime;
        return $this;
    }
    /**
     * Get ProfileFilter value
     * @return \MG\ArrayType\MGArrayOfWSProfileFilter|null
     */
    public function getProfileFilter()
    {
        return $this->ProfileFilter;
    }
    /**
     * Set ProfileFilter value
     * @param \MG\ArrayType\MGArrayOfWSProfileFilter $profileFilter
     * @return \MG\StructType\MGScheduleSendListMessageWithProfileFilter
     */
    public function setProfileFilter(\MG\ArrayType\MGArrayOfWSProfileFilter $profileFilter = null)
    {
        $this->ProfileFilter = $profileFilter;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \MG\StructType\MGScheduleSendListMessageWithProfileFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
