<?php

namespace MG\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReportContactLinkClick StructType
 * @package MG
 * @subpackage Structs
 */
class MGReportContactLinkClick extends AbstractStructBase
{
    /**
     * The LinkID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LinkID;
    /**
     * The Page
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Page;
    /**
     * The WSException
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \MG\StructType\MGWSException
     */
    public $WSException;
    /**
     * Constructor method for ReportContactLinkClick
     * @uses MGReportContactLinkClick::setLinkID()
     * @uses MGReportContactLinkClick::setPage()
     * @uses MGReportContactLinkClick::setWSException()
     * @param int $linkID
     * @param int $page
     * @param \MG\StructType\MGWSException $wSException
     */
    public function __construct($linkID = null, $page = null, \MG\StructType\MGWSException $wSException = null)
    {
        $this
            ->setLinkID($linkID)
            ->setPage($page)
            ->setWSException($wSException);
    }
    /**
     * Get LinkID value
     * @return int
     */
    public function getLinkID()
    {
        return $this->LinkID;
    }
    /**
     * Set LinkID value
     * @param int $linkID
     * @return \MG\StructType\MGReportContactLinkClick
     */
    public function setLinkID($linkID = null)
    {
        // validation for constraint: int
        if (!is_null($linkID) && !is_numeric($linkID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($linkID)), __LINE__);
        }
        $this->LinkID = $linkID;
        return $this;
    }
    /**
     * Get Page value
     * @return int
     */
    public function getPage()
    {
        return $this->Page;
    }
    /**
     * Set Page value
     * @param int $page
     * @return \MG\StructType\MGReportContactLinkClick
     */
    public function setPage($page = null)
    {
        // validation for constraint: int
        if (!is_null($page) && !is_numeric($page)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($page)), __LINE__);
        }
        $this->Page = $page;
        return $this;
    }
    /**
     * Get WSException value
     * @return \MG\StructType\MGWSException
     */
    public function getWSException()
    {
        return $this->WSException;
    }
    /**
     * Set WSException value
     * @param \MG\StructType\MGWSException $wSException
     * @return \MG\StructType\MGReportContactLinkClick
     */
    public function setWSException(\MG\StructType\MGWSException $wSException = null)
    {
        $this->WSException = $wSException;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \MG\StructType\MGReportContactLinkClick
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
