<?php

namespace MG\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteProfileAttribute StructType
 * @package MG
 * @subpackage Structs
 */
class MGDeleteProfileAttribute extends AbstractStructBase
{
    /**
     * The AttributeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AttributeID;
    /**
     * The WSException
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \MG\StructType\MGWSException
     */
    public $WSException;
    /**
     * Constructor method for DeleteProfileAttribute
     * @uses MGDeleteProfileAttribute::setAttributeID()
     * @uses MGDeleteProfileAttribute::setWSException()
     * @param int $attributeID
     * @param \MG\StructType\MGWSException $wSException
     */
    public function __construct($attributeID = null, \MG\StructType\MGWSException $wSException = null)
    {
        $this
            ->setAttributeID($attributeID)
            ->setWSException($wSException);
    }
    /**
     * Get AttributeID value
     * @return int
     */
    public function getAttributeID()
    {
        return $this->AttributeID;
    }
    /**
     * Set AttributeID value
     * @param int $attributeID
     * @return \MG\StructType\MGDeleteProfileAttribute
     */
    public function setAttributeID($attributeID = null)
    {
        // validation for constraint: int
        if (!is_null($attributeID) && !is_numeric($attributeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($attributeID)), __LINE__);
        }
        $this->AttributeID = $attributeID;
        return $this;
    }
    /**
     * Get WSException value
     * @return \MG\StructType\MGWSException
     */
    public function getWSException()
    {
        return $this->WSException;
    }
    /**
     * Set WSException value
     * @param \MG\StructType\MGWSException $wSException
     * @return \MG\StructType\MGDeleteProfileAttribute
     */
    public function setWSException(\MG\StructType\MGWSException $wSException = null)
    {
        $this->WSException = $wSException;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \MG\StructType\MGDeleteProfileAttribute
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
