<?php

namespace MG\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConductorBulkLoadAndTriggerContacts StructType
 * @package MG
 * @subpackage Structs
 */
class MGConductorBulkLoadAndTriggerContacts extends AbstractStructBase
{
    /**
     * The ListID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ListID;
    /**
     * The WSImportDirectives
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \MG\StructType\MGWSImportDirectives
     */
    public $WSImportDirectives;
    /**
     * The TriggerFileMappings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \MG\ArrayType\MGArrayOfWSTriggerFileMappings
     */
    public $TriggerFileMappings;
    /**
     * The ImportFileStream
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ImportFileStream;
    /**
     * Constructor method for ConductorBulkLoadAndTriggerContacts
     * @uses MGConductorBulkLoadAndTriggerContacts::setListID()
     * @uses MGConductorBulkLoadAndTriggerContacts::setWSImportDirectives()
     * @uses MGConductorBulkLoadAndTriggerContacts::setTriggerFileMappings()
     * @uses MGConductorBulkLoadAndTriggerContacts::setImportFileStream()
     * @param int $listID
     * @param \MG\StructType\MGWSImportDirectives $wSImportDirectives
     * @param \MG\ArrayType\MGArrayOfWSTriggerFileMappings $triggerFileMappings
     * @param string $importFileStream
     */
    public function __construct($listID = null, \MG\StructType\MGWSImportDirectives $wSImportDirectives = null, \MG\ArrayType\MGArrayOfWSTriggerFileMappings $triggerFileMappings = null, $importFileStream = null)
    {
        $this
            ->setListID($listID)
            ->setWSImportDirectives($wSImportDirectives)
            ->setTriggerFileMappings($triggerFileMappings)
            ->setImportFileStream($importFileStream);
    }
    /**
     * Get ListID value
     * @return int
     */
    public function getListID()
    {
        return $this->ListID;
    }
    /**
     * Set ListID value
     * @param int $listID
     * @return \MG\StructType\MGConductorBulkLoadAndTriggerContacts
     */
    public function setListID($listID = null)
    {
        // validation for constraint: int
        if (!is_null($listID) && !is_numeric($listID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($listID)), __LINE__);
        }
        $this->ListID = $listID;
        return $this;
    }
    /**
     * Get WSImportDirectives value
     * @return \MG\StructType\MGWSImportDirectives
     */
    public function getWSImportDirectives()
    {
        return $this->WSImportDirectives;
    }
    /**
     * Set WSImportDirectives value
     * @param \MG\StructType\MGWSImportDirectives $wSImportDirectives
     * @return \MG\StructType\MGConductorBulkLoadAndTriggerContacts
     */
    public function setWSImportDirectives(\MG\StructType\MGWSImportDirectives $wSImportDirectives = null)
    {
        $this->WSImportDirectives = $wSImportDirectives;
        return $this;
    }
    /**
     * Get TriggerFileMappings value
     * @return \MG\ArrayType\MGArrayOfWSTriggerFileMappings|null
     */
    public function getTriggerFileMappings()
    {
        return $this->TriggerFileMappings;
    }
    /**
     * Set TriggerFileMappings value
     * @param \MG\ArrayType\MGArrayOfWSTriggerFileMappings $triggerFileMappings
     * @return \MG\StructType\MGConductorBulkLoadAndTriggerContacts
     */
    public function setTriggerFileMappings(\MG\ArrayType\MGArrayOfWSTriggerFileMappings $triggerFileMappings = null)
    {
        $this->TriggerFileMappings = $triggerFileMappings;
        return $this;
    }
    /**
     * Get ImportFileStream value
     * @return string|null
     */
    public function getImportFileStream()
    {
        return $this->ImportFileStream;
    }
    /**
     * Set ImportFileStream value
     * @param string $importFileStream
     * @return \MG\StructType\MGConductorBulkLoadAndTriggerContacts
     */
    public function setImportFileStream($importFileStream = null)
    {
        // validation for constraint: string
        if (!is_null($importFileStream) && !is_string($importFileStream)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($importFileStream)), __LINE__);
        }
        $this->ImportFileStream = $importFileStream;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \MG\StructType\MGConductorBulkLoadAndTriggerContacts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
