<?php

namespace MG\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @package MG
 * @subpackage Services
 */
class MGDelete extends AbstractSoapClientBase
{
    /**
     * Sets the WSUser SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \MG\StructType\MGWSUser $wSUser
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWSUser(\MG\StructType\MGWSUser $wSUser, $nameSpace = 'http://webservices.listrak.com/v31/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'WSUser', $wSUser, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named
     * DeleteGoogleTrackingDomainsFromList
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Deletes Google Tracking Domains from the specified list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGDeleteGoogleTrackingDomainsFromList $parameters
     * @return \MG\StructType\MGDeleteGoogleTrackingDomainsFromListResponse|bool
     */
    public function DeleteGoogleTrackingDomainsFromList(\MG\StructType\MGDeleteGoogleTrackingDomainsFromList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteGoogleTrackingDomainsFromList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteContactList
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Deletes a contact list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGDeleteContactList $parameters
     * @return \MG\StructType\MGDeleteContactListResponse|bool
     */
    public function DeleteContactList(\MG\StructType\MGDeleteContactList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteContactList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteProfileHeader
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Deletes a profile header.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGDeleteProfileHeader $parameters
     * @return \MG\StructType\MGDeleteProfileHeaderResponse|bool
     */
    public function DeleteProfileHeader(\MG\StructType\MGDeleteProfileHeader $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteProfileHeader($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteProfileAttribute
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Deletes a profile attribute.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGDeleteProfileAttribute $parameters
     * @return \MG\StructType\MGDeleteProfileAttributeResponse|bool
     */
    public function DeleteProfileAttribute(\MG\StructType\MGDeleteProfileAttribute $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteProfileAttribute($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \MG\StructType\MGDeleteContactListResponse|\MG\StructType\MGDeleteGoogleTrackingDomainsFromListResponse|\MG\StructType\MGDeleteProfileAttributeResponse|\MG\StructType\MGDeleteProfileHeaderResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
