<?php

namespace MG\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWSSavedMessage ArrayType
 * @package MG
 * @subpackage Arrays
 */
class MGArrayOfWSSavedMessage extends AbstractStructArrayBase
{
    /**
     * The WSSavedMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \MG\StructType\MGWSSavedMessage[]
     */
    public $WSSavedMessage;
    /**
     * Constructor method for ArrayOfWSSavedMessage
     * @uses MGArrayOfWSSavedMessage::setWSSavedMessage()
     * @param \MG\StructType\MGWSSavedMessage[] $wSSavedMessage
     */
    public function __construct(array $wSSavedMessage = array())
    {
        $this
            ->setWSSavedMessage($wSSavedMessage);
    }
    /**
     * Get WSSavedMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \MG\StructType\MGWSSavedMessage[]|null
     */
    public function getWSSavedMessage()
    {
        return isset($this->WSSavedMessage) ? $this->WSSavedMessage : null;
    }
    /**
     * Set WSSavedMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \MG\StructType\MGWSSavedMessage[] $wSSavedMessage
     * @return \MG\ArrayType\MGArrayOfWSSavedMessage
     */
    public function setWSSavedMessage(array $wSSavedMessage = array())
    {
        foreach ($wSSavedMessage as $arrayOfWSSavedMessageWSSavedMessageItem) {
            // validation for constraint: itemType
            if (!$arrayOfWSSavedMessageWSSavedMessageItem instanceof \MG\StructType\MGWSSavedMessage) {
                throw new \InvalidArgumentException(sprintf('The WSSavedMessage property can only contain items of \MG\StructType\MGWSSavedMessage, "%s" given', is_object($arrayOfWSSavedMessageWSSavedMessageItem) ? get_class($arrayOfWSSavedMessageWSSavedMessageItem) : gettype($arrayOfWSSavedMessageWSSavedMessageItem)), __LINE__);
            }
        }
        if (is_null($wSSavedMessage) || (is_array($wSSavedMessage) && empty($wSSavedMessage))) {
            unset($this->WSSavedMessage);
        } else {
            $this->WSSavedMessage = $wSSavedMessage;
        }
        return $this;
    }
    /**
     * Add item to WSSavedMessage value
     * @throws \InvalidArgumentException
     * @param \MG\StructType\MGWSSavedMessage $item
     * @return \MG\ArrayType\MGArrayOfWSSavedMessage
     */
    public function addToWSSavedMessage(\MG\StructType\MGWSSavedMessage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \MG\StructType\MGWSSavedMessage) {
            throw new \InvalidArgumentException(sprintf('The WSSavedMessage property can only contain items of \MG\StructType\MGWSSavedMessage, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->WSSavedMessage[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \MG\StructType\MGWSSavedMessage|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \MG\StructType\MGWSSavedMessage|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \MG\StructType\MGWSSavedMessage|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \MG\StructType\MGWSSavedMessage|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \MG\StructType\MGWSSavedMessage|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WSSavedMessage
     */
    public function getAttributeName()
    {
        return 'WSSavedMessage';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \MG\ArrayType\MGArrayOfWSSavedMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
