<?php

namespace MG\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WSSpamScore StructType
 * @package MG
 * @subpackage Structs
 */
class MGWSSpamScore extends AbstractStructBase
{
    /**
     * The PointsReceived
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PointsReceived;
    /**
     * The PointsRequired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PointsRequired;
    /**
     * The Scores
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \MG\StructType\MGSpamAssassinScore[]
     */
    public $Scores;
    /**
     * Constructor method for WSSpamScore
     * @uses MGWSSpamScore::setPointsReceived()
     * @uses MGWSSpamScore::setPointsRequired()
     * @uses MGWSSpamScore::setScores()
     * @param float $pointsReceived
     * @param float $pointsRequired
     * @param \MG\StructType\MGSpamAssassinScore[] $scores
     */
    public function __construct($pointsReceived = null, $pointsRequired = null, array $scores = array())
    {
        $this
            ->setPointsReceived($pointsReceived)
            ->setPointsRequired($pointsRequired)
            ->setScores($scores);
    }
    /**
     * Get PointsReceived value
     * @return float
     */
    public function getPointsReceived()
    {
        return $this->PointsReceived;
    }
    /**
     * Set PointsReceived value
     * @param float $pointsReceived
     * @return \MG\StructType\MGWSSpamScore
     */
    public function setPointsReceived($pointsReceived = null)
    {
        $this->PointsReceived = $pointsReceived;
        return $this;
    }
    /**
     * Get PointsRequired value
     * @return float
     */
    public function getPointsRequired()
    {
        return $this->PointsRequired;
    }
    /**
     * Set PointsRequired value
     * @param float $pointsRequired
     * @return \MG\StructType\MGWSSpamScore
     */
    public function setPointsRequired($pointsRequired = null)
    {
        $this->PointsRequired = $pointsRequired;
        return $this;
    }
    /**
     * Get Scores value
     * @return \MG\StructType\MGSpamAssassinScore[]|null
     */
    public function getScores()
    {
        return $this->Scores;
    }
    /**
     * Set Scores value
     * @throws \InvalidArgumentException
     * @param \MG\StructType\MGSpamAssassinScore[] $scores
     * @return \MG\StructType\MGWSSpamScore
     */
    public function setScores(array $scores = array())
    {
        foreach ($scores as $wSSpamScoreScoresItem) {
            // validation for constraint: itemType
            if (!$wSSpamScoreScoresItem instanceof \MG\StructType\MGSpamAssassinScore) {
                throw new \InvalidArgumentException(sprintf('The Scores property can only contain items of \MG\StructType\MGSpamAssassinScore, "%s" given', is_object($wSSpamScoreScoresItem) ? get_class($wSSpamScoreScoresItem) : gettype($wSSpamScoreScoresItem)), __LINE__);
            }
        }
        $this->Scores = $scores;
        return $this;
    }
    /**
     * Add item to Scores value
     * @throws \InvalidArgumentException
     * @param \MG\StructType\MGSpamAssassinScore $item
     * @return \MG\StructType\MGWSSpamScore
     */
    public function addToScores(\MG\StructType\MGSpamAssassinScore $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \MG\StructType\MGSpamAssassinScore) {
            throw new \InvalidArgumentException(sprintf('The Scores property can only contain items of \MG\StructType\MGSpamAssassinScore, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Scores[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \MG\StructType\MGWSSpamScore
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
