<?php

namespace MG\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendTransactionalMessage StructType
 * @package MG
 * @subpackage Structs
 */
class MGSendTransactionalMessage extends AbstractStructBase
{
    /**
     * The TransactionalMsgID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransactionalMsgID;
    /**
     * The EmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailAddress;
    /**
     * The ProfileData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \MG\ArrayType\MGArrayOfWSProfileAttributeValue
     */
    public $ProfileData;
    /**
     * Constructor method for SendTransactionalMessage
     * @uses MGSendTransactionalMessage::setTransactionalMsgID()
     * @uses MGSendTransactionalMessage::setEmailAddress()
     * @uses MGSendTransactionalMessage::setProfileData()
     * @param int $transactionalMsgID
     * @param string $emailAddress
     * @param \MG\ArrayType\MGArrayOfWSProfileAttributeValue $profileData
     */
    public function __construct($transactionalMsgID = null, $emailAddress = null, \MG\ArrayType\MGArrayOfWSProfileAttributeValue $profileData = null)
    {
        $this
            ->setTransactionalMsgID($transactionalMsgID)
            ->setEmailAddress($emailAddress)
            ->setProfileData($profileData);
    }
    /**
     * Get TransactionalMsgID value
     * @return int
     */
    public function getTransactionalMsgID()
    {
        return $this->TransactionalMsgID;
    }
    /**
     * Set TransactionalMsgID value
     * @param int $transactionalMsgID
     * @return \MG\StructType\MGSendTransactionalMessage
     */
    public function setTransactionalMsgID($transactionalMsgID = null)
    {
        // validation for constraint: int
        if (!is_null($transactionalMsgID) && !is_numeric($transactionalMsgID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transactionalMsgID)), __LINE__);
        }
        $this->TransactionalMsgID = $transactionalMsgID;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \MG\StructType\MGSendTransactionalMessage
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get ProfileData value
     * @return \MG\ArrayType\MGArrayOfWSProfileAttributeValue|null
     */
    public function getProfileData()
    {
        return $this->ProfileData;
    }
    /**
     * Set ProfileData value
     * @param \MG\ArrayType\MGArrayOfWSProfileAttributeValue $profileData
     * @return \MG\StructType\MGSendTransactionalMessage
     */
    public function setProfileData(\MG\ArrayType\MGArrayOfWSProfileAttributeValue $profileData = null)
    {
        $this->ProfileData = $profileData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \MG\StructType\MGSendTransactionalMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
