<?php

namespace MG\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetProfileHeaderCollection StructType
 * @package MG
 * @subpackage Structs
 */
class MGGetProfileHeaderCollection extends AbstractStructBase
{
    /**
     * The ListID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ListID;
    /**
     * The WSException
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \MG\StructType\MGWSException
     */
    public $WSException;
    /**
     * Constructor method for GetProfileHeaderCollection
     * @uses MGGetProfileHeaderCollection::setListID()
     * @uses MGGetProfileHeaderCollection::setWSException()
     * @param int $listID
     * @param \MG\StructType\MGWSException $wSException
     */
    public function __construct($listID = null, \MG\StructType\MGWSException $wSException = null)
    {
        $this
            ->setListID($listID)
            ->setWSException($wSException);
    }
    /**
     * Get ListID value
     * @return int
     */
    public function getListID()
    {
        return $this->ListID;
    }
    /**
     * Set ListID value
     * @param int $listID
     * @return \MG\StructType\MGGetProfileHeaderCollection
     */
    public function setListID($listID = null)
    {
        // validation for constraint: int
        if (!is_null($listID) && !is_numeric($listID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($listID)), __LINE__);
        }
        $this->ListID = $listID;
        return $this;
    }
    /**
     * Get WSException value
     * @return \MG\StructType\MGWSException
     */
    public function getWSException()
    {
        return $this->WSException;
    }
    /**
     * Set WSException value
     * @param \MG\StructType\MGWSException $wSException
     * @return \MG\StructType\MGGetProfileHeaderCollection
     */
    public function setWSException(\MG\StructType\MGWSException $wSException = null)
    {
        $this->WSException = $wSException;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \MG\StructType\MGGetProfileHeaderCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
