<?php

namespace MG\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @package MG
 * @subpackage Services
 */
class MGUpdate extends AbstractSoapClientBase
{
    /**
     * Sets the WSUser SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \MG\StructType\MGWSUser $wSUser
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWSUser(\MG\StructType\MGWSUser $wSUser, $nameSpace = 'http://webservices.listrak.com/v31/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'WSUser', $wSUser, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named UpdateSubscribedContactAttribute
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Updates the specified attribute value for all subscribed contacts on the list associated to the given attribute.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGUpdateSubscribedContactAttribute $parameters
     * @return \MG\StructType\MGUpdateSubscribedContactAttributeResponse|bool
     */
    public function UpdateSubscribedContactAttribute(\MG\StructType\MGUpdateSubscribedContactAttribute $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateSubscribedContactAttribute($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * UpdateSubscribedContactAttributeWithOptions
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Updates the specified attribute value for all subscribed contacts on the list associated to the given attribute with configurable options.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGUpdateSubscribedContactAttributeWithOptions $parameters
     * @return \MG\StructType\MGUpdateSubscribedContactAttributeWithOptionsResponse|bool
     */
    public function UpdateSubscribedContactAttributeWithOptions(\MG\StructType\MGUpdateSubscribedContactAttributeWithOptions $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateSubscribedContactAttributeWithOptions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateContactList
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Updates a standard contact list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGUpdateContactList $parameters
     * @return \MG\StructType\MGUpdateContactListResponse|bool
     */
    public function UpdateContactList(\MG\StructType\MGUpdateContactList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateContactList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateProfileHeader
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Updates a profile header.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGUpdateProfileHeader $parameters
     * @return \MG\StructType\MGUpdateProfileHeaderResponse|bool
     */
    public function UpdateProfileHeader(\MG\StructType\MGUpdateProfileHeader $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateProfileHeader($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateProfileAttribute
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Updates a profile attribute.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGUpdateProfileAttribute $parameters
     * @return \MG\StructType\MGUpdateProfileAttributeResponse|bool
     */
    public function UpdateProfileAttribute(\MG\StructType\MGUpdateProfileAttribute $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateProfileAttribute($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateContact
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Attempts to update a subscribed contact of the specified list with profile data and external events.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGUpdateContact $parameters
     * @return \MG\StructType\MGUpdateContactResponse|bool
     */
    public function UpdateContact(\MG\StructType\MGUpdateContact $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateContact($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \MG\StructType\MGUpdateContactListResponse|\MG\StructType\MGUpdateContactResponse|\MG\StructType\MGUpdateProfileAttributeResponse|\MG\StructType\MGUpdateProfileHeaderResponse|\MG\StructType\MGUpdateSubscribedContactAttributeResponse|\MG\StructType\MGUpdateSubscribedContactAttributeWithOptionsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
