<?php

namespace MG\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Subscribe ServiceType
 * @package MG
 * @subpackage Services
 */
class MGSubscribe extends AbstractSoapClientBase
{
    /**
     * Sets the WSUser SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \MG\StructType\MGWSUser $wSUser
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWSUser(\MG\StructType\MGWSUser $wSUser, $nameSpace = 'http://webservices.listrak.com/v31/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'WSUser', $wSUser, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named SubscribeFormPassThrough
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Mimics a subscribe form submission.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGSubscribeFormPassThrough $parameters
     * @return \MG\StructType\MGSubscribeFormPassThroughResponse|bool
     */
    public function SubscribeFormPassThrough(\MG\StructType\MGSubscribeFormPassThrough $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SubscribeFormPassThrough($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SubscribeContact
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Attempts to subscribe a contact to the specified list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGSubscribeContact $parameters
     * @return \MG\StructType\MGSubscribeContactResponse|bool
     */
    public function SubscribeContact(\MG\StructType\MGSubscribeContact $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SubscribeContact($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \MG\StructType\MGSubscribeContactResponse|\MG\StructType\MGSubscribeFormPassThroughResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
