<?php

namespace MG\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Report ServiceType
 * @package MG
 * @subpackage Services
 */
class MGReport extends AbstractSoapClientBase
{
    /**
     * Sets the WSUser SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \MG\StructType\MGWSUser $wSUser
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWSUser(\MG\StructType\MGWSUser $wSUser, $nameSpace = 'http://webservices.listrak.com/v31/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'WSUser', $wSUser, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ReportSubscribedContacts
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of contacts who are currently subscribed to the specified list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportSubscribedContacts $parameters
     * @return \MG\StructType\MGReportSubscribedContactsResponse|bool
     */
    public function ReportSubscribedContacts(\MG\StructType\MGReportSubscribedContacts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportSubscribedContacts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportRangeSubscribedContacts
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of contacts who are currently subscribed to the specified list within the specified date range.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportRangeSubscribedContacts $parameters
     * @return \MG\StructType\MGReportRangeSubscribedContactsResponse|bool
     */
    public function ReportRangeSubscribedContacts(\MG\StructType\MGReportRangeSubscribedContacts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportRangeSubscribedContacts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportAdminContactFeedbackLoop
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of feedback loop listings for the specified date range. This report spans all lists that the API user can access.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportAdminContactFeedbackLoop $parameters
     * @return \MG\StructType\MGReportAdminContactFeedbackLoopResponse|bool
     */
    public function ReportAdminContactFeedbackLoop(\MG\StructType\MGReportAdminContactFeedbackLoop $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportAdminContactFeedbackLoop($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportMessageContactSent
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of contacts who were sent the specified message.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportMessageContactSent $parameters
     * @return \MG\StructType\MGReportMessageContactSentResponse|bool
     */
    public function ReportMessageContactSent(\MG\StructType\MGReportMessageContactSent $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportMessageContactSent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportMessageContactOpen
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of contact opens for a message.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportMessageContactOpen $parameters
     * @return \MG\StructType\MGReportMessageContactOpenResponse|bool
     */
    public function ReportMessageContactOpen(\MG\StructType\MGReportMessageContactOpen $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportMessageContactOpen($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportRangeMessageContactOpen
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of contact opens for a message within the specified date range.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportRangeMessageContactOpen $parameters
     * @return \MG\StructType\MGReportRangeMessageContactOpenResponse|bool
     */
    public function ReportRangeMessageContactOpen(\MG\StructType\MGReportRangeMessageContactOpen $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportRangeMessageContactOpen($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportMessageContactRead
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of contact reads for a message.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportMessageContactRead $parameters
     * @return \MG\StructType\MGReportMessageContactReadResponse|bool
     */
    public function ReportMessageContactRead(\MG\StructType\MGReportMessageContactRead $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportMessageContactRead($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportRangeMessageContactRead
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of contact reads for a message within the specified date range.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportRangeMessageContactRead $parameters
     * @return \MG\StructType\MGReportRangeMessageContactReadResponse|bool
     */
    public function ReportRangeMessageContactRead(\MG\StructType\MGReportRangeMessageContactRead $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportRangeMessageContactRead($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportMessageContactClick
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of contact clicks for a message.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportMessageContactClick $parameters
     * @return \MG\StructType\MGReportMessageContactClickResponse|bool
     */
    public function ReportMessageContactClick(\MG\StructType\MGReportMessageContactClick $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportMessageContactClick($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportRangeMessageContactClick
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of contact clicks for a message within the specified date range.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportRangeMessageContactClick $parameters
     * @return \MG\StructType\MGReportRangeMessageContactClickResponse|bool
     */
    public function ReportRangeMessageContactClick(\MG\StructType\MGReportRangeMessageContactClick $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportRangeMessageContactClick($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportMessageContactPassalong
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of contact passalongs for a message.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportMessageContactPassalong $parameters
     * @return \MG\StructType\MGReportMessageContactPassalongResponse|bool
     */
    public function ReportMessageContactPassalong(\MG\StructType\MGReportMessageContactPassalong $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportMessageContactPassalong($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportRangeMessageContactPassalong
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of contact passalongs for a message within the specified date range.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportRangeMessageContactPassalong $parameters
     * @return \MG\StructType\MGReportRangeMessageContactPassalongResponse|bool
     */
    public function ReportRangeMessageContactPassalong(\MG\StructType\MGReportRangeMessageContactPassalong $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportRangeMessageContactPassalong($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportMessageContactBounces
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of contact bounces for a message.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportMessageContactBounces $parameters
     * @return \MG\StructType\MGReportMessageContactBouncesResponse|bool
     */
    public function ReportMessageContactBounces(\MG\StructType\MGReportMessageContactBounces $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportMessageContactBounces($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportRangeMessageContactBounces
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of contact bounces for a message within the specified date range.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportRangeMessageContactBounces $parameters
     * @return \MG\StructType\MGReportRangeMessageContactBouncesResponse|bool
     */
    public function ReportRangeMessageContactBounces(\MG\StructType\MGReportRangeMessageContactBounces $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportRangeMessageContactBounces($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportListMessageActivity
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of message statistics for a message sent to a list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportListMessageActivity $parameters
     * @return \MG\StructType\MGReportListMessageActivityResponse|bool
     */
    public function ReportListMessageActivity(\MG\StructType\MGReportListMessageActivity $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportListMessageActivity($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportListMessageDelivery
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of message statistics for a message sent to a list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportListMessageDelivery $parameters
     * @return \MG\StructType\MGReportListMessageDeliveryResponse|bool
     */
    public function ReportListMessageDelivery(\MG\StructType\MGReportListMessageDelivery $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportListMessageDelivery($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportListContactRemoval
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of all contacts whom requested to be removed from the supplied list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportListContactRemoval $parameters
     * @return \MG\StructType\MGReportListContactRemovalResponse|bool
     */
    public function ReportListContactRemoval(\MG\StructType\MGReportListContactRemoval $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportListContactRemoval($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportRangeListContactRemoval
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of all contacts whom requested to be removed from the supplied list within the specified date range.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportRangeListContactRemoval $parameters
     * @return \MG\StructType\MGReportRangeListContactRemovalResponse|bool
     */
    public function ReportRangeListContactRemoval(\MG\StructType\MGReportRangeListContactRemoval $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportRangeListContactRemoval($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportListContactHygiene
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of all contacts whose addresses have been changed by list hygiene.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportListContactHygiene $parameters
     * @return \MG\StructType\MGReportListContactHygieneResponse|bool
     */
    public function ReportListContactHygiene(\MG\StructType\MGReportListContactHygiene $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportListContactHygiene($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportRangeListContactHygiene
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of all contacts whose addresses have been changed by list hygiene within the specified date range.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportRangeListContactHygiene $parameters
     * @return \MG\StructType\MGReportRangeListContactHygieneResponse|bool
     */
    public function ReportRangeListContactHygiene(\MG\StructType\MGReportRangeListContactHygiene $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportRangeListContactHygiene($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportMessageLinkClick
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of click statistics for links contained within a message.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportMessageLinkClick $parameters
     * @return \MG\StructType\MGReportMessageLinkClickResponse|bool
     */
    public function ReportMessageLinkClick(\MG\StructType\MGReportMessageLinkClick $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportMessageLinkClick($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportContactLinkClick
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of contacts and their click history for a link.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportContactLinkClick $parameters
     * @return \MG\StructType\MGReportContactLinkClickResponse|bool
     */
    public function ReportContactLinkClick(\MG\StructType\MGReportContactLinkClick $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportContactLinkClick($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportMessageLocationClick
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of geographical click location statistics for links contained within a message.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportMessageLocationClick $parameters
     * @return \MG\StructType\MGReportMessageLocationClickResponse|bool
     */
    public function ReportMessageLocationClick(\MG\StructType\MGReportMessageLocationClick $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportMessageLocationClick($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportMessageLocationOpen
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of geographical message open locations and statistics for a message.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportMessageLocationOpen $parameters
     * @return \MG\StructType\MGReportMessageLocationOpenResponse|bool
     */
    public function ReportMessageLocationOpen(\MG\StructType\MGReportMessageLocationOpen $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportMessageLocationOpen($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportMessageLocationRead
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of geographical message read locations and statistics for a message.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportMessageLocationRead $parameters
     * @return \MG\StructType\MGReportMessageLocationReadResponse|bool
     */
    public function ReportMessageLocationRead(\MG\StructType\MGReportMessageLocationRead $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportMessageLocationRead($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportMessageLocationContactClick
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of contacts who clicked within the supplied message and geographical location.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportMessageLocationContactClick $parameters
     * @return \MG\StructType\MGReportMessageLocationContactClickResponse|bool
     */
    public function ReportMessageLocationContactClick(\MG\StructType\MGReportMessageLocationContactClick $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportMessageLocationContactClick($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportMessageLocationContactOpen
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of contacts who opened the supplied message in the defined geographical location.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportMessageLocationContactOpen $parameters
     * @return \MG\StructType\MGReportMessageLocationContactOpenResponse|bool
     */
    public function ReportMessageLocationContactOpen(\MG\StructType\MGReportMessageLocationContactOpen $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportMessageLocationContactOpen($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportMessageLocationContactRead
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of contacts who read the supplied message in the defined geographical location.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportMessageLocationContactRead $parameters
     * @return \MG\StructType\MGReportMessageLocationContactReadResponse|bool
     */
    public function ReportMessageLocationContactRead(\MG\StructType\MGReportMessageLocationContactRead $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportMessageLocationContactRead($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportMessageContactActivity
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: [Deprecated] Retrieves a collection of contacts and their open, read and click statistics for the supplied message.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportMessageContactActivity $parameters
     * @return \MG\StructType\MGReportMessageContactActivityResponse|bool
     */
    public function ReportMessageContactActivity(\MG\StructType\MGReportMessageContactActivity $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportMessageContactActivity($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportRangeMessageContactRemoval
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of contacts whom requested to be removed from a list from the supplied message within the specified date range.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportRangeMessageContactRemoval $parameters
     * @return \MG\StructType\MGReportRangeMessageContactRemovalResponse|bool
     */
    public function ReportRangeMessageContactRemoval(\MG\StructType\MGReportRangeMessageContactRemoval $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportRangeMessageContactRemoval($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportMessageContactRemoval
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of contacts whom requested to be removed from a list from the supplied message.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportMessageContactRemoval $parameters
     * @return \MG\StructType\MGReportMessageContactRemovalResponse|bool
     */
    public function ReportMessageContactRemoval(\MG\StructType\MGReportMessageContactRemoval $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportMessageContactRemoval($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportContactMessageActivity
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a contact's message activity history for the define list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportContactMessageActivity $parameters
     * @return \MG\StructType\MGReportContactMessageActivityResponse|bool
     */
    public function ReportContactMessageActivity(\MG\StructType\MGReportContactMessageActivity $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportContactMessageActivity($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportListImportHistory
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of import results for the specified list and date range.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportListImportHistory $parameters
     * @return \MG\StructType\MGReportListImportHistoryResponse|bool
     */
    public function ReportListImportHistory(\MG\StructType\MGReportListImportHistory $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportListImportHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportImportContactDetail
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of import contacts for the specified import file.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportImportContactDetail $parameters
     * @return \MG\StructType\MGReportImportContactDetailResponse|bool
     */
    public function ReportImportContactDetail(\MG\StructType\MGReportImportContactDetail $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportImportContactDetail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportListConversationActivity
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of conversation statistics for conversations active within a list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportListConversationActivity $parameters
     * @return \MG\StructType\MGReportListConversationActivityResponse|bool
     */
    public function ReportListConversationActivity(\MG\StructType\MGReportListConversationActivity $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportListConversationActivity($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportListConversationDelivery
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of conversation statistics for conversations delivery info within a list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportListConversationDelivery $parameters
     * @return \MG\StructType\MGReportListConversationDeliveryResponse|bool
     */
    public function ReportListConversationDelivery(\MG\StructType\MGReportListConversationDelivery $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportListConversationDelivery($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportConversationContactDelivery
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of conversation statistics for contacts who were sent messages by the specified conversation.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportConversationContactDelivery $parameters
     * @return \MG\StructType\MGReportConversationContactDeliveryResponse|bool
     */
    public function ReportConversationContactDelivery(\MG\StructType\MGReportConversationContactDelivery $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportConversationContactDelivery($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportConversationContactRemoval
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of conversation statistics for contacts who were removed during a specified conversation.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportConversationContactRemoval $parameters
     * @return \MG\StructType\MGReportConversationContactRemovalResponse|bool
     */
    public function ReportConversationContactRemoval(\MG\StructType\MGReportConversationContactRemoval $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportConversationContactRemoval($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportConversationContactOpen
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of conversation statistics for contacts who opened a message sent during a specified conversation.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportConversationContactOpen $parameters
     * @return \MG\StructType\MGReportConversationContactOpenResponse|bool
     */
    public function ReportConversationContactOpen(\MG\StructType\MGReportConversationContactOpen $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportConversationContactOpen($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportConversationContactRead
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of conversation statistics for contacts who read a message sent during a specified conversation.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportConversationContactRead $parameters
     * @return \MG\StructType\MGReportConversationContactReadResponse|bool
     */
    public function ReportConversationContactRead(\MG\StructType\MGReportConversationContactRead $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportConversationContactRead($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportConversationLinkClick
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of conversation statistics for contacts who clicked a link found in a message sent during a specified conversation.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportConversationLinkClick $parameters
     * @return \MG\StructType\MGReportConversationLinkClickResponse|bool
     */
    public function ReportConversationLinkClick(\MG\StructType\MGReportConversationLinkClick $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportConversationLinkClick($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReportConversationContactBounce
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of conversation statistics for contacts bounced from a message sent during a specified conversation.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportConversationContactBounce $parameters
     * @return \MG\StructType\MGReportConversationContactBounceResponse|bool
     */
    public function ReportConversationContactBounce(\MG\StructType\MGReportConversationContactBounce $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportConversationContactBounce($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ReportConversationLocationContactOpen
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of geological statistics for contacts who opened a message sent during a specified conversation.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportConversationLocationContactOpen $parameters
     * @return \MG\StructType\MGReportConversationLocationContactOpenResponse|bool
     */
    public function ReportConversationLocationContactOpen(\MG\StructType\MGReportConversationLocationContactOpen $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportConversationLocationContactOpen($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ReportConversationLocationContactRead
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of geological statistics for contacts who read a message sent during a specified conversation.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportConversationLocationContactRead $parameters
     * @return \MG\StructType\MGReportConversationLocationContactReadResponse|bool
     */
    public function ReportConversationLocationContactRead(\MG\StructType\MGReportConversationLocationContactRead $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportConversationLocationContactRead($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ReportConversationLocationContactClick
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of geological statistics for contacts who clicked on a link found in a message sent during a specified conversation.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGReportConversationLocationContactClick $parameters
     * @return \MG\StructType\MGReportConversationLocationContactClickResponse|bool
     */
    public function ReportConversationLocationContactClick(\MG\StructType\MGReportConversationLocationContactClick $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReportConversationLocationContactClick($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \MG\StructType\MGReportAdminContactFeedbackLoopResponse|\MG\StructType\MGReportContactLinkClickResponse|\MG\StructType\MGReportContactMessageActivityResponse|\MG\StructType\MGReportConversationContactBounceResponse|\MG\StructType\MGReportConversationContactDeliveryResponse|\MG\StructType\MGReportConversationContactOpenResponse|\MG\StructType\MGReportConversationContactReadResponse|\MG\StructType\MGReportConversationContactRemovalResponse|\MG\StructType\MGReportConversationLinkClickResponse|\MG\StructType\MGReportConversationLocationContactClickResponse|\MG\StructType\MGReportConversationLocationContactOpenResponse|\MG\StructType\MGReportConversationLocationContactReadResponse|\MG\StructType\MGReportImportContactDetailResponse|\MG\StructType\MGReportListContactHygieneResponse|\MG\StructType\MGReportListContactRemovalResponse|\MG\StructType\MGReportListConversationActivityResponse|\MG\StructType\MGReportListConversationDeliveryResponse|\MG\StructType\MGReportListImportHistoryResponse|\MG\StructType\MGReportListMessageActivityResponse|\MG\StructType\MGReportListMessageDeliveryResponse|\MG\StructType\MGReportMessageContactActivityResponse|\MG\StructType\MGReportMessageContactBouncesResponse|\MG\StructType\MGReportMessageContactClickResponse|\MG\StructType\MGReportMessageContactOpenResponse|\MG\StructType\MGReportMessageContactPassalongResponse|\MG\StructType\MGReportMessageContactReadResponse|\MG\StructType\MGReportMessageContactRemovalResponse|\MG\StructType\MGReportMessageContactSentResponse|\MG\StructType\MGReportMessageLinkClickResponse|\MG\StructType\MGReportMessageLocationClickResponse|\MG\StructType\MGReportMessageLocationContactClickResponse|\MG\StructType\MGReportMessageLocationContactOpenResponse|\MG\StructType\MGReportMessageLocationContactReadResponse|\MG\StructType\MGReportMessageLocationOpenResponse|\MG\StructType\MGReportMessageLocationReadResponse|\MG\StructType\MGReportRangeListContactHygieneResponse|\MG\StructType\MGReportRangeListContactRemovalResponse|\MG\StructType\MGReportRangeMessageContactBouncesResponse|\MG\StructType\MGReportRangeMessageContactClickResponse|\MG\StructType\MGReportRangeMessageContactOpenResponse|\MG\StructType\MGReportRangeMessageContactPassalongResponse|\MG\StructType\MGReportRangeMessageContactReadResponse|\MG\StructType\MGReportRangeMessageContactRemovalResponse|\MG\StructType\MGReportRangeSubscribedContactsResponse|\MG\StructType\MGReportSubscribedContactsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
