<?php

namespace MG\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @package MG
 * @subpackage Services
 */
class MGGet extends AbstractSoapClientBase
{
    /**
     * Sets the WSUser SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \MG\StructType\MGWSUser $wSUser
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWSUser(\MG\StructType\MGWSUser $wSUser, $nameSpace = 'http://webservices.listrak.com/v31/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'WSUser', $wSUser, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetProcessStatus
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Provides status information for asynchronous processes such as imports and dynamic profile updates that maybe running against a account.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGGetProcessStatus $parameters
     * @return \MG\StructType\MGGetProcessStatusResponse|bool
     */
    public function GetProcessStatus(\MG\StructType\MGGetProcessStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProcessStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMessageStatus
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Provides message status for deployments that maybe running against a account.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGGetMessageStatus $parameters
     * @return \MG\StructType\MGGetMessageStatusResponse|bool
     */
    public function GetMessageStatus(\MG\StructType\MGGetMessageStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetMessageStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLegacyProcessStatus
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: [Deprecated: Please use GetProcessStatus.] Provides status information for asynchronous legacy processes such as the XML over HTTP "Send to List" and "Send to File" calls.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGGetLegacyProcessStatus $parameters
     * @return \MG\StructType\MGGetLegacyProcessStatusResponse|bool
     */
    public function GetLegacyProcessStatus(\MG\StructType\MGGetLegacyProcessStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetLegacyProcessStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccountVmtaCollection
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of TCP/IP Pools that are assigned to a account.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGGetAccountVmtaCollection $parameters
     * @return \MG\StructType\MGGetAccountVmtaCollectionResponse|bool
     */
    public function GetAccountVmtaCollection(\MG\StructType\MGGetAccountVmtaCollection $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAccountVmtaCollection($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetContactList
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves the list settings for a standard contact list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGGetContactList $parameters
     * @return \MG\StructType\MGGetContactListResponse|bool
     */
    public function GetContactList(\MG\StructType\MGGetContactList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetContactList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetContactListCollection
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of lists assigned to the user executing the request.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGGetContactListCollection $parameters
     * @return \MG\StructType\MGGetContactListCollectionResponse|bool
     */
    public function GetContactListCollection(\MG\StructType\MGGetContactListCollection $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetContactListCollection($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProfileHeaderCollection
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of a list's profile headers.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGGetProfileHeaderCollection $parameters
     * @return \MG\StructType\MGGetProfileHeaderCollectionResponse|bool
     */
    public function GetProfileHeaderCollection(\MG\StructType\MGGetProfileHeaderCollection $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProfileHeaderCollection($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetContact
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Returns a contact and corresponding profile information.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGGetContact $parameters
     * @return \MG\StructType\MGGetContactResponse|bool
     */
    public function GetContact(\MG\StructType\MGGetContact $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetContact($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetContactByEmailKey
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Returns a contact and corresponding profile information.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGGetContactByEmailKey $parameters
     * @return \MG\StructType\MGGetContactByEmailKeyResponse|bool
     */
    public function GetContactByEmailKey(\MG\StructType\MGGetContactByEmailKey $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetContactByEmailKey($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTransactionalMessageCollection
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of transactional messages for the specified list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGGetTransactionalMessageCollection $parameters
     * @return \MG\StructType\MGGetTransactionalMessageCollectionResponse|bool
     */
    public function GetTransactionalMessageCollection(\MG\StructType\MGGetTransactionalMessageCollection $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetTransactionalMessageCollection($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMessageAnalyticsInformation
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Provides message analytics information for messages that have been sent. This method has a limit of 2,500 messages per call as of 4/5/2016.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGGetMessageAnalyticsInformation $parameters
     * @return \MG\StructType\MGGetMessageAnalyticsInformationResponse|bool
     */
    public function GetMessageAnalyticsInformation(\MG\StructType\MGGetMessageAnalyticsInformation $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetMessageAnalyticsInformation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSpamScore
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Provides SPAM Score information for a message and contact.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGGetSpamScore $parameters
     * @return \MG\StructType\MGGetSpamScoreResponse|bool
     */
    public function GetSpamScore(\MG\StructType\MGGetSpamScore $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSpamScore($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCampaignCollection
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of campaigns that are define for the supplied list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGGetCampaignCollection $parameters
     * @return \MG\StructType\MGGetCampaignCollectionResponse|bool
     */
    public function GetCampaignCollection(\MG\StructType\MGGetCampaignCollection $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCampaignCollection($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCharacterSetCollection
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Retrieves a collection of character sets that are supported by Listrak.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGGetCharacterSetCollection $parameters
     * @return \MG\StructType\MGGetCharacterSetCollectionResponse|bool
     */
    public function GetCharacterSetCollection(\MG\StructType\MGGetCharacterSetCollection $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCharacterSetCollection($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSavedMessageCollection
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Returns a collection of saved messages found within the supplied list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGGetSavedMessageCollection $parameters
     * @return \MG\StructType\MGGetSavedMessageCollectionResponse|bool
     */
    public function GetSavedMessageCollection(\MG\StructType\MGGetSavedMessageCollection $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSavedMessageCollection($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFilteredListCount
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Returns the number of contacts that match the supplied filter and list identifier.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGGetFilteredListCount $parameters
     * @return \MG\StructType\MGGetFilteredListCountResponse|bool
     */
    public function GetFilteredListCount(\MG\StructType\MGGetFilteredListCount $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetFilteredListCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSystemIDFromPublicID
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Reverses public-facing ID values to integer-based ID values.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGGetSystemIDFromPublicID $parameters
     * @return \MG\StructType\MGGetSystemIDFromPublicIDResponse|bool
     */
    public function GetSystemIDFromPublicID(\MG\StructType\MGGetSystemIDFromPublicID $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSystemIDFromPublicID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \MG\StructType\MGGetAccountVmtaCollectionResponse|\MG\StructType\MGGetCampaignCollectionResponse|\MG\StructType\MGGetCharacterSetCollectionResponse|\MG\StructType\MGGetContactByEmailKeyResponse|\MG\StructType\MGGetContactListCollectionResponse|\MG\StructType\MGGetContactListResponse|\MG\StructType\MGGetContactResponse|\MG\StructType\MGGetFilteredListCountResponse|\MG\StructType\MGGetLegacyProcessStatusResponse|\MG\StructType\MGGetMessageAnalyticsInformationResponse|\MG\StructType\MGGetMessageStatusResponse|\MG\StructType\MGGetProcessStatusResponse|\MG\StructType\MGGetProfileHeaderCollectionResponse|\MG\StructType\MGGetSavedMessageCollectionResponse|\MG\StructType\MGGetSpamScoreResponse|\MG\StructType\MGGetSystemIDFromPublicIDResponse|\MG\StructType\MGGetTransactionalMessageCollectionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
