<?php

namespace MG\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Conductor ServiceType
 * @package MG
 * @subpackage Services
 */
class MGConductor extends AbstractSoapClientBase
{
    /**
     * Sets the WSUser SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \MG\StructType\MGWSUser $wSUser
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWSUser(\MG\StructType\MGWSUser $wSUser, $nameSpace = 'http://webservices.listrak.com/v31/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'WSUser', $wSUser, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named
     * ConductorBulkLoadAndTriggerContacts
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Facilitates loading contact data via a import file stream to the specified list and triggering a event for each contact.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGConductorBulkLoadAndTriggerContacts $parameters
     * @return \MG\StructType\MGConductorBulkLoadAndTriggerContactsResponse|bool
     */
    public function ConductorBulkLoadAndTriggerContacts(\MG\StructType\MGConductorBulkLoadAndTriggerContacts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ConductorBulkLoadAndTriggerContacts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ConductorBulkLoadAndTriggerContactsWithOptions
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Facilitates loading contact data via a import file stream to the specified list with configurable options.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGConductorBulkLoadAndTriggerContactsWithOptions $parameters
     * @return \MG\StructType\MGConductorBulkLoadAndTriggerContactsWithOptionsResponse|bool
     */
    public function ConductorBulkLoadAndTriggerContactsWithOptions(\MG\StructType\MGConductorBulkLoadAndTriggerContactsWithOptions $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ConductorBulkLoadAndTriggerContactsWithOptions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConductorGetExternalEvents
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Returns a collection of External Events defined for a list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGConductorGetExternalEvents $parameters
     * @return \MG\StructType\MGConductorGetExternalEventsResponse|bool
     */
    public function ConductorGetExternalEvents(\MG\StructType\MGConductorGetExternalEvents $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ConductorGetExternalEvents($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConductorGetConversations
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Returns a collection of conversations defined for a list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGConductorGetConversations $parameters
     * @return \MG\StructType\MGConductorGetConversationsResponse|bool
     */
    public function ConductorGetConversations(\MG\StructType\MGConductorGetConversations $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ConductorGetConversations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \MG\StructType\MGConductorBulkLoadAndTriggerContactsResponse|\MG\StructType\MGConductorBulkLoadAndTriggerContactsWithOptionsResponse|\MG\StructType\MGConductorGetConversationsResponse|\MG\StructType\MGConductorGetExternalEventsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
