<?php

namespace MG\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Bulk ServiceType
 * @package MG
 * @subpackage Services
 */
class MGBulk extends AbstractSoapClientBase
{
    /**
     * Sets the WSUser SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \MG\StructType\MGWSUser $wSUser
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWSUser(\MG\StructType\MGWSUser $wSUser, $nameSpace = 'http://webservices.listrak.com/v31/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'WSUser', $wSUser, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named BulkLoadContacts
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Facilitates loading contact data via a import file stream to the specified list.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGBulkLoadContacts $parameters
     * @return \MG\StructType\MGBulkLoadContactsResponse|bool
     */
    public function BulkLoadContacts(\MG\StructType\MGBulkLoadContacts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->BulkLoadContacts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named BulkLoadContactsWithOptions
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames : WSUser
     * - SOAPHeaderNamespaces : http://webservices.listrak.com/v31/
     * - SOAPHeaderTypes : \MG\StructType\MGWSUser
     * - SOAPHeaders : required
     * - documentation: Facilitates loading contact data via a import file stream to the specified list with configurable options.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \MG\StructType\MGBulkLoadContactsWithOptions $parameters
     * @return \MG\StructType\MGBulkLoadContactsWithOptionsResponse|bool
     */
    public function BulkLoadContactsWithOptions(\MG\StructType\MGBulkLoadContactsWithOptions $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->BulkLoadContactsWithOptions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \MG\StructType\MGBulkLoadContactsResponse|\MG\StructType\MGBulkLoadContactsWithOptionsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
