<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://cloudconnector.apptitude.nl/services/api/3.0?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://cloudconnector.apptitude.nl/services/api/3.0?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \ApptitudeNamespace\ClassMap::get(),
);
/**
 * Samples for Update ServiceType
 */
$update = new \ApptitudeNamespace\ServiceType\Update($options);
/**
 * Sample call for updateStock operation/method
 */
if ($update->updateStock(new \ApptitudeNamespace\StructType\UpdateStock()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updatePrices operation/method
 */
if ($update->updatePrices(new \ApptitudeNamespace\StructType\UpdatePrices()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ApptitudeNamespace\ServiceType\Get($options);
/**
 * Sample call for getOrders operation/method
 */
if ($get->getOrders(new \ApptitudeNamespace\StructType\GetOrders()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getUnprocessedOrders operation/method
 */
if ($get->getUnprocessedOrders(new \ApptitudeNamespace\StructType\GetUnprocessedOrders()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAllProducts operation/method
 */
if ($get->getAllProducts(new \ApptitudeNamespace\StructType\GetAllProducts()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getInfo operation/method
 */
if ($get->getInfo(new \ApptitudeNamespace\StructType\GetInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Store ServiceType
 */
$store = new \ApptitudeNamespace\ServiceType\Store($options);
/**
 * Sample call for storeFullProductSet operation/method
 */
if ($store->storeFullProductSet(new \ApptitudeNamespace\StructType\StoreFullProductSet()) !== false) {
    print_r($store->getResult());
} else {
    print_r($store->getLastError());
}
/**
 * Sample call for storeProducts operation/method
 */
if ($store->storeProducts(new \ApptitudeNamespace\StructType\StoreProducts()) !== false) {
    print_r($store->getResult());
} else {
    print_r($store->getLastError());
}
/**
 * Sample call for storeFullCustomerSet operation/method
 */
if ($store->storeFullCustomerSet(new \ApptitudeNamespace\StructType\StoreFullCustomerSet()) !== false) {
    print_r($store->getResult());
} else {
    print_r($store->getLastError());
}
/**
 * Sample call for storeCustomers operation/method
 */
if ($store->storeCustomers(new \ApptitudeNamespace\StructType\StoreCustomers()) !== false) {
    print_r($store->getResult());
} else {
    print_r($store->getLastError());
}
/**
 * Sample call for storeFullCustomerAccessSetForAgent operation/method
 */
if ($store->storeFullCustomerAccessSetForAgent(new \ApptitudeNamespace\StructType\StoreFullCustomerAccessSetForAgent()) !== false) {
    print_r($store->getResult());
} else {
    print_r($store->getLastError());
}
/**
 * Sample call for storeFullCustomerAccessSet operation/method
 */
if ($store->storeFullCustomerAccessSet(new \ApptitudeNamespace\StructType\StoreFullCustomerAccessSet()) !== false) {
    print_r($store->getResult());
} else {
    print_r($store->getLastError());
}
/**
 * Sample call for storeFullProductAccessSet operation/method
 */
if ($store->storeFullProductAccessSet(new \ApptitudeNamespace\StructType\StoreFullProductAccessSet()) !== false) {
    print_r($store->getResult());
} else {
    print_r($store->getLastError());
}
/**
 * Sample call for storeProductAccessRules operation/method
 */
if ($store->storeProductAccessRules(new \ApptitudeNamespace\StructType\StoreProductAccessRules()) !== false) {
    print_r($store->getResult());
} else {
    print_r($store->getLastError());
}
/**
 * Sample call for storeFullHistoricalOrderSetForCustomer operation/method
 */
if ($store->storeFullHistoricalOrderSetForCustomer(new \ApptitudeNamespace\StructType\StoreFullHistoricalOrderSetForCustomer()) !== false) {
    print_r($store->getResult());
} else {
    print_r($store->getLastError());
}
/**
 * Sample call for storeHistoricalOrders operation/method
 */
if ($store->storeHistoricalOrders(new \ApptitudeNamespace\StructType\StoreHistoricalOrders()) !== false) {
    print_r($store->getResult());
} else {
    print_r($store->getLastError());
}
/**
 * Sample call for storeFullInvoiceSetForCustomer operation/method
 */
if ($store->storeFullInvoiceSetForCustomer(new \ApptitudeNamespace\StructType\StoreFullInvoiceSetForCustomer()) !== false) {
    print_r($store->getResult());
} else {
    print_r($store->getLastError());
}
/**
 * Sample call for storeInvoices operation/method
 */
if ($store->storeInvoices(new \ApptitudeNamespace\StructType\StoreInvoices()) !== false) {
    print_r($store->getResult());
} else {
    print_r($store->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ApptitudeNamespace\ServiceType\Delete($options);
/**
 * Sample call for deleteProducts operation/method
 */
if ($delete->deleteProducts(new \ApptitudeNamespace\StructType\DeleteProducts()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteAllProducts operation/method
 */
if ($delete->deleteAllProducts(new \ApptitudeNamespace\StructType\DeleteAllProducts()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteCustomers operation/method
 */
if ($delete->deleteCustomers(new \ApptitudeNamespace\StructType\DeleteCustomers()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteAllCustomers operation/method
 */
if ($delete->deleteAllCustomers(new \ApptitudeNamespace\StructType\DeleteAllCustomers()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteProductAccessRulesForCustomer operation/method
 */
if ($delete->deleteProductAccessRulesForCustomer(new \ApptitudeNamespace\StructType\DeleteProductAccessRulesForCustomer()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteProductAccessRules operation/method
 */
if ($delete->deleteProductAccessRules(new \ApptitudeNamespace\StructType\DeleteProductAccessRules()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteAllProductAccessRules operation/method
 */
if ($delete->deleteAllProductAccessRules(new \ApptitudeNamespace\StructType\DeleteAllProductAccessRules()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteHistoricalOrders operation/method
 */
if ($delete->deleteHistoricalOrders(new \ApptitudeNamespace\StructType\DeleteHistoricalOrders()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteAllHistoricalOrders operation/method
 */
if ($delete->deleteAllHistoricalOrders(new \ApptitudeNamespace\StructType\DeleteAllHistoricalOrders()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteInvoices operation/method
 */
if ($delete->deleteInvoices(new \ApptitudeNamespace\StructType\DeleteInvoices()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteAllInvoices operation/method
 */
if ($delete->deleteAllInvoices(new \ApptitudeNamespace\StructType\DeleteAllInvoices()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Mark ServiceType
 */
$mark = new \ApptitudeNamespace\ServiceType\Mark($options);
/**
 * Sample call for markOrdersAsProcessed operation/method
 */
if ($mark->markOrdersAsProcessed(new \ApptitudeNamespace\StructType\MarkOrdersAsProcessed()) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
