<?php

namespace ApptitudeNamespace\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for xSize30 StructType
 * @subpackage Structs
 */
class XSize30 extends XObject30
{
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The sortCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sortCode;
    /**
     * The subSizeName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subSizeName;
    /**
     * The subSizeSortCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $subSizeSortCode;
    /**
     * The prePackUnitCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $prePackUnitCount;
    /**
     * The eanCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $eanCode;
    /**
     * The replenishmentDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $replenishmentDate;
    /**
     * The orderRoundingQuantity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $orderRoundingQuantity;
    /**
     * The customField
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customField;
    /**
     * The prepackContentElement
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ApptitudeNamespace\StructType\XPrepackContentElement30[]
     */
    public $prepackContentElement;
    /**
     * The accessCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accessCode;
    /**
     * The stockLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \ApptitudeNamespace\StructType\XStockLevel30[]
     */
    public $stockLevel;
    /**
     * Constructor method for xSize30
     * @uses XSize30::setName()
     * @uses XSize30::setSortCode()
     * @uses XSize30::setSubSizeName()
     * @uses XSize30::setSubSizeSortCode()
     * @uses XSize30::setPrePackUnitCount()
     * @uses XSize30::setEanCode()
     * @uses XSize30::setReplenishmentDate()
     * @uses XSize30::setOrderRoundingQuantity()
     * @uses XSize30::setCustomField()
     * @uses XSize30::setPrepackContentElement()
     * @uses XSize30::setAccessCode()
     * @uses XSize30::setStockLevel()
     * @param string $name
     * @param int $sortCode
     * @param string $subSizeName
     * @param int $subSizeSortCode
     * @param int $prePackUnitCount
     * @param string $eanCode
     * @param string $replenishmentDate
     * @param int $orderRoundingQuantity
     * @param string $customField
     * @param \ApptitudeNamespace\StructType\XPrepackContentElement30[] $prepackContentElement
     * @param string $accessCode
     * @param \ApptitudeNamespace\StructType\XStockLevel30[] $stockLevel
     */
    public function __construct($name = null, $sortCode = null, $subSizeName = null, $subSizeSortCode = null, $prePackUnitCount = null, $eanCode = null, $replenishmentDate = null, $orderRoundingQuantity = null, $customField = null, array $prepackContentElement = array(), $accessCode = null, array $stockLevel = array())
    {
        $this
            ->setName($name)
            ->setSortCode($sortCode)
            ->setSubSizeName($subSizeName)
            ->setSubSizeSortCode($subSizeSortCode)
            ->setPrePackUnitCount($prePackUnitCount)
            ->setEanCode($eanCode)
            ->setReplenishmentDate($replenishmentDate)
            ->setOrderRoundingQuantity($orderRoundingQuantity)
            ->setCustomField($customField)
            ->setPrepackContentElement($prepackContentElement)
            ->setAccessCode($accessCode)
            ->setStockLevel($stockLevel);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \ApptitudeNamespace\StructType\XSize30
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get sortCode value
     * @return int|null
     */
    public function getSortCode()
    {
        return $this->sortCode;
    }
    /**
     * Set sortCode value
     * @param int $sortCode
     * @return \ApptitudeNamespace\StructType\XSize30
     */
    public function setSortCode($sortCode = null)
    {
        // validation for constraint: int
        if (!is_null($sortCode) && !is_numeric($sortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sortCode)), __LINE__);
        }
        $this->sortCode = $sortCode;
        return $this;
    }
    /**
     * Get subSizeName value
     * @return string|null
     */
    public function getSubSizeName()
    {
        return $this->subSizeName;
    }
    /**
     * Set subSizeName value
     * @param string $subSizeName
     * @return \ApptitudeNamespace\StructType\XSize30
     */
    public function setSubSizeName($subSizeName = null)
    {
        // validation for constraint: string
        if (!is_null($subSizeName) && !is_string($subSizeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subSizeName)), __LINE__);
        }
        $this->subSizeName = $subSizeName;
        return $this;
    }
    /**
     * Get subSizeSortCode value
     * @return int|null
     */
    public function getSubSizeSortCode()
    {
        return $this->subSizeSortCode;
    }
    /**
     * Set subSizeSortCode value
     * @param int $subSizeSortCode
     * @return \ApptitudeNamespace\StructType\XSize30
     */
    public function setSubSizeSortCode($subSizeSortCode = null)
    {
        // validation for constraint: int
        if (!is_null($subSizeSortCode) && !is_numeric($subSizeSortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($subSizeSortCode)), __LINE__);
        }
        $this->subSizeSortCode = $subSizeSortCode;
        return $this;
    }
    /**
     * Get prePackUnitCount value
     * @return int|null
     */
    public function getPrePackUnitCount()
    {
        return $this->prePackUnitCount;
    }
    /**
     * Set prePackUnitCount value
     * @param int $prePackUnitCount
     * @return \ApptitudeNamespace\StructType\XSize30
     */
    public function setPrePackUnitCount($prePackUnitCount = null)
    {
        // validation for constraint: int
        if (!is_null($prePackUnitCount) && !is_numeric($prePackUnitCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($prePackUnitCount)), __LINE__);
        }
        $this->prePackUnitCount = $prePackUnitCount;
        return $this;
    }
    /**
     * Get eanCode value
     * @return string|null
     */
    public function getEanCode()
    {
        return $this->eanCode;
    }
    /**
     * Set eanCode value
     * @param string $eanCode
     * @return \ApptitudeNamespace\StructType\XSize30
     */
    public function setEanCode($eanCode = null)
    {
        // validation for constraint: string
        if (!is_null($eanCode) && !is_string($eanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eanCode)), __LINE__);
        }
        $this->eanCode = $eanCode;
        return $this;
    }
    /**
     * Get replenishmentDate value
     * @return string|null
     */
    public function getReplenishmentDate()
    {
        return $this->replenishmentDate;
    }
    /**
     * Set replenishmentDate value
     * @param string $replenishmentDate
     * @return \ApptitudeNamespace\StructType\XSize30
     */
    public function setReplenishmentDate($replenishmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($replenishmentDate) && !is_string($replenishmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($replenishmentDate)), __LINE__);
        }
        $this->replenishmentDate = $replenishmentDate;
        return $this;
    }
    /**
     * Get orderRoundingQuantity value
     * @return int|null
     */
    public function getOrderRoundingQuantity()
    {
        return $this->orderRoundingQuantity;
    }
    /**
     * Set orderRoundingQuantity value
     * @param int $orderRoundingQuantity
     * @return \ApptitudeNamespace\StructType\XSize30
     */
    public function setOrderRoundingQuantity($orderRoundingQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($orderRoundingQuantity) && !is_numeric($orderRoundingQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($orderRoundingQuantity)), __LINE__);
        }
        $this->orderRoundingQuantity = $orderRoundingQuantity;
        return $this;
    }
    /**
     * Get customField value
     * @return string|null
     */
    public function getCustomField()
    {
        return $this->customField;
    }
    /**
     * Set customField value
     * @param string $customField
     * @return \ApptitudeNamespace\StructType\XSize30
     */
    public function setCustomField($customField = null)
    {
        // validation for constraint: string
        if (!is_null($customField) && !is_string($customField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customField)), __LINE__);
        }
        $this->customField = $customField;
        return $this;
    }
    /**
     * Get prepackContentElement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ApptitudeNamespace\StructType\XPrepackContentElement30[]|null
     */
    public function getPrepackContentElement()
    {
        return isset($this->prepackContentElement) ? $this->prepackContentElement : null;
    }
    /**
     * Set prepackContentElement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XPrepackContentElement30[] $prepackContentElement
     * @return \ApptitudeNamespace\StructType\XSize30
     */
    public function setPrepackContentElement(array $prepackContentElement = array())
    {
        foreach ($prepackContentElement as $xSize30PrepackContentElementItem) {
            // validation for constraint: itemType
            if (!$xSize30PrepackContentElementItem instanceof \ApptitudeNamespace\StructType\XPrepackContentElement30) {
                throw new \InvalidArgumentException(sprintf('The prepackContentElement property can only contain items of \ApptitudeNamespace\StructType\XPrepackContentElement30, "%s" given', is_object($xSize30PrepackContentElementItem) ? get_class($xSize30PrepackContentElementItem) : gettype($xSize30PrepackContentElementItem)), __LINE__);
            }
        }
        if (is_null($prepackContentElement) || (is_array($prepackContentElement) && empty($prepackContentElement))) {
            unset($this->prepackContentElement);
        } else {
            $this->prepackContentElement = $prepackContentElement;
        }
        return $this;
    }
    /**
     * Add item to prepackContentElement value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XPrepackContentElement30 $item
     * @return \ApptitudeNamespace\StructType\XSize30
     */
    public function addToPrepackContentElement(\ApptitudeNamespace\StructType\XPrepackContentElement30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XPrepackContentElement30) {
            throw new \InvalidArgumentException(sprintf('The prepackContentElement property can only contain items of \ApptitudeNamespace\StructType\XPrepackContentElement30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->prepackContentElement[] = $item;
        return $this;
    }
    /**
     * Get accessCode value
     * @return string|null
     */
    public function getAccessCode()
    {
        return $this->accessCode;
    }
    /**
     * Set accessCode value
     * @param string $accessCode
     * @return \ApptitudeNamespace\StructType\XSize30
     */
    public function setAccessCode($accessCode = null)
    {
        // validation for constraint: string
        if (!is_null($accessCode) && !is_string($accessCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accessCode)), __LINE__);
        }
        $this->accessCode = $accessCode;
        return $this;
    }
    /**
     * Get stockLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ApptitudeNamespace\StructType\XStockLevel30[]|null
     */
    public function getStockLevel()
    {
        return isset($this->stockLevel) ? $this->stockLevel : null;
    }
    /**
     * Set stockLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XStockLevel30[] $stockLevel
     * @return \ApptitudeNamespace\StructType\XSize30
     */
    public function setStockLevel(array $stockLevel = array())
    {
        foreach ($stockLevel as $xSize30StockLevelItem) {
            // validation for constraint: itemType
            if (!$xSize30StockLevelItem instanceof \ApptitudeNamespace\StructType\XStockLevel30) {
                throw new \InvalidArgumentException(sprintf('The stockLevel property can only contain items of \ApptitudeNamespace\StructType\XStockLevel30, "%s" given', is_object($xSize30StockLevelItem) ? get_class($xSize30StockLevelItem) : gettype($xSize30StockLevelItem)), __LINE__);
            }
        }
        if (is_null($stockLevel) || (is_array($stockLevel) && empty($stockLevel))) {
            unset($this->stockLevel);
        } else {
            $this->stockLevel = $stockLevel;
        }
        return $this;
    }
    /**
     * Add item to stockLevel value
     * @throws \InvalidArgumentException
     * @param \ApptitudeNamespace\StructType\XStockLevel30 $item
     * @return \ApptitudeNamespace\StructType\XSize30
     */
    public function addToStockLevel(\ApptitudeNamespace\StructType\XStockLevel30 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ApptitudeNamespace\StructType\XStockLevel30) {
            throw new \InvalidArgumentException(sprintf('The stockLevel property can only contain items of \ApptitudeNamespace\StructType\XStockLevel30, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->stockLevel[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \ApptitudeNamespace\StructType\XSize30
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
